/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.KeyReference;
import com.commercetools.graphql.api.types.MessagePayload;
import com.commercetools.graphql.api.types.Reference;
import com.commercetools.graphql.api.types.VariantTailoring;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class ProductVariantTailoringAdded
implements MessagePayload {
    private Integer variantId;
    private KeyReference storeRef;
    private Reference productRef;
    private String productKey;
    private VariantTailoring variant;
    private String type;

    public ProductVariantTailoringAdded() {
    }

    public ProductVariantTailoringAdded(Integer variantId, KeyReference storeRef, Reference productRef, String productKey, VariantTailoring variant, String type) {
        this.variantId = variantId;
        this.storeRef = storeRef;
        this.productRef = productRef;
        this.productKey = productKey;
        this.variant = variant;
        this.type = type;
    }

    public Integer getVariantId() {
        return this.variantId;
    }

    public void setVariantId(Integer variantId) {
        this.variantId = variantId;
    }

    public KeyReference getStoreRef() {
        return this.storeRef;
    }

    public void setStoreRef(KeyReference storeRef) {
        this.storeRef = storeRef;
    }

    public Reference getProductRef() {
        return this.productRef;
    }

    public void setProductRef(Reference productRef) {
        this.productRef = productRef;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public void setProductKey(String productKey) {
        this.productKey = productKey;
    }

    public VariantTailoring getVariant() {
        return this.variant;
    }

    public void setVariant(VariantTailoring variant) {
        this.variant = variant;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "ProductVariantTailoringAdded{variantId='" + this.variantId + "',storeRef='" + this.storeRef + "',productRef='" + this.productRef + "',productKey='" + this.productKey + "',variant='" + this.variant + "',type='" + this.type + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductVariantTailoringAdded that = (ProductVariantTailoringAdded)o;
        return Objects.equals(this.variantId, that.variantId) && Objects.equals(this.storeRef, that.storeRef) && Objects.equals(this.productRef, that.productRef) && Objects.equals(this.productKey, that.productKey) && Objects.equals(this.variant, that.variant) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.variantId, this.storeRef, this.productRef, this.productKey, this.variant, this.type);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Integer variantId;
        private KeyReference storeRef;
        private Reference productRef;
        private String productKey;
        private VariantTailoring variant;
        private String type;

        public ProductVariantTailoringAdded build() {
            ProductVariantTailoringAdded result = new ProductVariantTailoringAdded();
            result.variantId = this.variantId;
            result.storeRef = this.storeRef;
            result.productRef = this.productRef;
            result.productKey = this.productKey;
            result.variant = this.variant;
            result.type = this.type;
            return result;
        }

        public Builder variantId(Integer variantId) {
            this.variantId = variantId;
            return this;
        }

        public Builder storeRef(KeyReference storeRef) {
            this.storeRef = storeRef;
            return this;
        }

        public Builder productRef(Reference productRef) {
            this.productRef = productRef;
            return this;
        }

        public Builder productKey(String productKey) {
            this.productKey = productKey;
            return this;
        }

        public Builder variant(VariantTailoring variant) {
            this.variant = variant;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }
    }
}

