/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.ReturnItem;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

public class ReturnInfo {
    private List<ReturnItem> items;
    private String returnTrackingId;
    private OffsetDateTime returnDate;

    public ReturnInfo() {
    }

    public ReturnInfo(List<ReturnItem> items, String returnTrackingId, OffsetDateTime returnDate) {
        this.items = items;
        this.returnTrackingId = returnTrackingId;
        this.returnDate = returnDate;
    }

    public List<ReturnItem> getItems() {
        return this.items;
    }

    public void setItems(List<ReturnItem> items) {
        this.items = items;
    }

    public String getReturnTrackingId() {
        return this.returnTrackingId;
    }

    public void setReturnTrackingId(String returnTrackingId) {
        this.returnTrackingId = returnTrackingId;
    }

    public OffsetDateTime getReturnDate() {
        return this.returnDate;
    }

    public void setReturnDate(OffsetDateTime returnDate) {
        this.returnDate = returnDate;
    }

    public String toString() {
        return "ReturnInfo{items='" + this.items + "',returnTrackingId='" + this.returnTrackingId + "',returnDate='" + this.returnDate + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReturnInfo that = (ReturnInfo)o;
        return Objects.equals(this.items, that.items) && Objects.equals(this.returnTrackingId, that.returnTrackingId) && Objects.equals(this.returnDate, that.returnDate);
    }

    public int hashCode() {
        return Objects.hash(this.items, this.returnTrackingId, this.returnDate);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private List<ReturnItem> items;
        private String returnTrackingId;
        private OffsetDateTime returnDate;

        public ReturnInfo build() {
            ReturnInfo result = new ReturnInfo();
            result.items = this.items;
            result.returnTrackingId = this.returnTrackingId;
            result.returnDate = this.returnDate;
            return result;
        }

        public Builder items(List<ReturnItem> items) {
            this.items = items;
            return this;
        }

        public Builder returnTrackingId(String returnTrackingId) {
            this.returnTrackingId = returnTrackingId;
            return this;
        }

        public Builder returnDate(OffsetDateTime returnDate) {
            this.returnDate = returnDate;
            return this;
        }
    }
}

