/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.CustomerSearchConfiguration;
import com.commercetools.graphql.api.types.OrderSearchConfiguration;
import com.commercetools.graphql.api.types.SearchIndexingConfigurationValues;
import java.util.Objects;

public class SearchIndexingConfiguration {
    private SearchIndexingConfigurationValues products;
    private OrderSearchConfiguration orders;
    private CustomerSearchConfiguration customers;

    public SearchIndexingConfiguration() {
    }

    public SearchIndexingConfiguration(SearchIndexingConfigurationValues products, OrderSearchConfiguration orders, CustomerSearchConfiguration customers) {
        this.products = products;
        this.orders = orders;
        this.customers = customers;
    }

    public SearchIndexingConfigurationValues getProducts() {
        return this.products;
    }

    public void setProducts(SearchIndexingConfigurationValues products) {
        this.products = products;
    }

    public OrderSearchConfiguration getOrders() {
        return this.orders;
    }

    public void setOrders(OrderSearchConfiguration orders) {
        this.orders = orders;
    }

    public CustomerSearchConfiguration getCustomers() {
        return this.customers;
    }

    public void setCustomers(CustomerSearchConfiguration customers) {
        this.customers = customers;
    }

    public String toString() {
        return "SearchIndexingConfiguration{products='" + this.products + "',orders='" + this.orders + "',customers='" + this.customers + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchIndexingConfiguration that = (SearchIndexingConfiguration)o;
        return Objects.equals(this.products, that.products) && Objects.equals(this.orders, that.orders) && Objects.equals(this.customers, that.customers);
    }

    public int hashCode() {
        return Objects.hash(this.products, this.orders, this.customers);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private SearchIndexingConfigurationValues products;
        private OrderSearchConfiguration orders;
        private CustomerSearchConfiguration customers;

        public SearchIndexingConfiguration build() {
            SearchIndexingConfiguration result = new SearchIndexingConfiguration();
            result.products = this.products;
            result.orders = this.orders;
            result.customers = this.customers;
            return result;
        }

        public Builder products(SearchIndexingConfigurationValues products) {
            this.products = products;
            return this;
        }

        public Builder orders(OrderSearchConfiguration orders) {
            this.orders = orders;
            return this;
        }

        public Builder customers(CustomerSearchConfiguration customers) {
            this.customers = customers;
            return this;
        }
    }
}

