/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.ProductSelection;
import com.commercetools.graphql.api.types.ProductVariantExclusion;
import com.commercetools.graphql.api.types.ProductVariantSelection;
import com.commercetools.graphql.api.types.Reference;
import java.time.OffsetDateTime;
import java.util.Objects;

public class SelectionOfProduct {
    private Reference productSelectionRef;
    private ProductSelection productSelection;
    private ProductVariantSelection variantSelection;
    private ProductVariantExclusion variantExclusion;
    private OffsetDateTime createdAt;

    public SelectionOfProduct() {
    }

    public SelectionOfProduct(Reference productSelectionRef, ProductSelection productSelection, ProductVariantSelection variantSelection, ProductVariantExclusion variantExclusion, OffsetDateTime createdAt) {
        this.productSelectionRef = productSelectionRef;
        this.productSelection = productSelection;
        this.variantSelection = variantSelection;
        this.variantExclusion = variantExclusion;
        this.createdAt = createdAt;
    }

    public Reference getProductSelectionRef() {
        return this.productSelectionRef;
    }

    public void setProductSelectionRef(Reference productSelectionRef) {
        this.productSelectionRef = productSelectionRef;
    }

    public ProductSelection getProductSelection() {
        return this.productSelection;
    }

    public void setProductSelection(ProductSelection productSelection) {
        this.productSelection = productSelection;
    }

    public ProductVariantSelection getVariantSelection() {
        return this.variantSelection;
    }

    public void setVariantSelection(ProductVariantSelection variantSelection) {
        this.variantSelection = variantSelection;
    }

    public ProductVariantExclusion getVariantExclusion() {
        return this.variantExclusion;
    }

    public void setVariantExclusion(ProductVariantExclusion variantExclusion) {
        this.variantExclusion = variantExclusion;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public String toString() {
        return "SelectionOfProduct{productSelectionRef='" + this.productSelectionRef + "',productSelection='" + this.productSelection + "',variantSelection='" + this.variantSelection + "',variantExclusion='" + this.variantExclusion + "',createdAt='" + this.createdAt + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectionOfProduct that = (SelectionOfProduct)o;
        return Objects.equals(this.productSelectionRef, that.productSelectionRef) && Objects.equals(this.productSelection, that.productSelection) && Objects.equals(this.variantSelection, that.variantSelection) && Objects.equals(this.variantExclusion, that.variantExclusion) && Objects.equals(this.createdAt, that.createdAt);
    }

    public int hashCode() {
        return Objects.hash(this.productSelectionRef, this.productSelection, this.variantSelection, this.variantExclusion, this.createdAt);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Reference productSelectionRef;
        private ProductSelection productSelection;
        private ProductVariantSelection variantSelection;
        private ProductVariantExclusion variantExclusion;
        private OffsetDateTime createdAt;

        public SelectionOfProduct build() {
            SelectionOfProduct result = new SelectionOfProduct();
            result.productSelectionRef = this.productSelectionRef;
            result.productSelection = this.productSelection;
            result.variantSelection = this.variantSelection;
            result.variantExclusion = this.variantExclusion;
            result.createdAt = this.createdAt;
            return result;
        }

        public Builder productSelectionRef(Reference productSelectionRef) {
            this.productSelectionRef = productSelectionRef;
            return this;
        }

        public Builder productSelection(ProductSelection productSelection) {
            this.productSelection = productSelection;
            return this;
        }

        public Builder variantSelection(ProductVariantSelection variantSelection) {
            this.variantSelection = variantSelection;
            return this;
        }

        public Builder variantExclusion(ProductVariantExclusion variantExclusion) {
            this.variantExclusion = variantExclusion;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }
    }
}

