/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.Money;
import com.commercetools.graphql.api.types.ShippingRatePriceTier;
import java.util.List;
import java.util.Objects;

public class ShippingRate {
    private Money price;
    private Money freeAbove;
    private Boolean isMatching;
    private List<ShippingRatePriceTier> tiers;

    public ShippingRate() {
    }

    public ShippingRate(Money price, Money freeAbove, Boolean isMatching, List<ShippingRatePriceTier> tiers) {
        this.price = price;
        this.freeAbove = freeAbove;
        this.isMatching = isMatching;
        this.tiers = tiers;
    }

    public Money getPrice() {
        return this.price;
    }

    public void setPrice(Money price) {
        this.price = price;
    }

    public Money getFreeAbove() {
        return this.freeAbove;
    }

    public void setFreeAbove(Money freeAbove) {
        this.freeAbove = freeAbove;
    }

    public Boolean getIsMatching() {
        return this.isMatching;
    }

    public void setIsMatching(Boolean isMatching) {
        this.isMatching = isMatching;
    }

    public List<ShippingRatePriceTier> getTiers() {
        return this.tiers;
    }

    public void setTiers(List<ShippingRatePriceTier> tiers) {
        this.tiers = tiers;
    }

    public String toString() {
        return "ShippingRate{price='" + this.price + "',freeAbove='" + this.freeAbove + "',isMatching='" + this.isMatching + "',tiers='" + this.tiers + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShippingRate that = (ShippingRate)o;
        return Objects.equals(this.price, that.price) && Objects.equals(this.freeAbove, that.freeAbove) && Objects.equals(this.isMatching, that.isMatching) && Objects.equals(this.tiers, that.tiers);
    }

    public int hashCode() {
        return Objects.hash(this.price, this.freeAbove, this.isMatching, this.tiers);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Money price;
        private Money freeAbove;
        private Boolean isMatching;
        private List<ShippingRatePriceTier> tiers;

        public ShippingRate build() {
            ShippingRate result = new ShippingRate();
            result.price = this.price;
            result.freeAbove = this.freeAbove;
            result.isMatching = this.isMatching;
            result.tiers = this.tiers;
            return result;
        }

        public Builder price(Money price) {
            this.price = price;
            return this;
        }

        public Builder freeAbove(Money freeAbove) {
            this.freeAbove = freeAbove;
            return this;
        }

        public Builder isMatching(Boolean isMatching) {
            this.isMatching = isMatching;
            return this;
        }

        public Builder tiers(List<ShippingRatePriceTier> tiers) {
            this.tiers = tiers;
            return this;
        }
    }
}

