/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.Initiator;
import com.commercetools.graphql.api.types.LocalizedString;
import com.commercetools.graphql.api.types.Reference;
import com.commercetools.graphql.api.types.ReferenceExpandable;
import com.commercetools.graphql.api.types.StateRole;
import com.commercetools.graphql.api.types.StateType;
import com.commercetools.graphql.api.types.Versioned;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class State
implements Versioned,
ReferenceExpandable {
    private String id;
    private Long version;
    private String key;
    private StateType type;
    private List<StateRole> roles;
    private String name;
    private List<LocalizedString> nameAllLocales;
    private String description;
    private List<LocalizedString> descriptionAllLocales;
    private Boolean builtIn;
    private List<Reference> transitionsRef;
    private List<State> transitions;
    private Boolean initial;
    private OffsetDateTime createdAt;
    private OffsetDateTime lastModifiedAt;
    private Initiator createdBy;
    private Initiator lastModifiedBy;

    public State() {
    }

    public State(String id, Long version, String key, StateType type, List<StateRole> roles, String name, List<LocalizedString> nameAllLocales, String description, List<LocalizedString> descriptionAllLocales, Boolean builtIn, List<Reference> transitionsRef, List<State> transitions, Boolean initial, OffsetDateTime createdAt, OffsetDateTime lastModifiedAt, Initiator createdBy, Initiator lastModifiedBy) {
        this.id = id;
        this.version = version;
        this.key = key;
        this.type = type;
        this.roles = roles;
        this.name = name;
        this.nameAllLocales = nameAllLocales;
        this.description = description;
        this.descriptionAllLocales = descriptionAllLocales;
        this.builtIn = builtIn;
        this.transitionsRef = transitionsRef;
        this.transitions = transitions;
        this.initial = initial;
        this.createdAt = createdAt;
        this.lastModifiedAt = lastModifiedAt;
        this.createdBy = createdBy;
        this.lastModifiedBy = lastModifiedBy;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Long getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(Long version) {
        this.version = version;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public StateType getType() {
        return this.type;
    }

    public void setType(StateType type) {
        this.type = type;
    }

    public List<StateRole> getRoles() {
        return this.roles;
    }

    public void setRoles(List<StateRole> roles) {
        this.roles = roles;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<LocalizedString> getNameAllLocales() {
        return this.nameAllLocales;
    }

    public void setNameAllLocales(List<LocalizedString> nameAllLocales) {
        this.nameAllLocales = nameAllLocales;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<LocalizedString> getDescriptionAllLocales() {
        return this.descriptionAllLocales;
    }

    public void setDescriptionAllLocales(List<LocalizedString> descriptionAllLocales) {
        this.descriptionAllLocales = descriptionAllLocales;
    }

    public Boolean getBuiltIn() {
        return this.builtIn;
    }

    public void setBuiltIn(Boolean builtIn) {
        this.builtIn = builtIn;
    }

    public List<Reference> getTransitionsRef() {
        return this.transitionsRef;
    }

    public void setTransitionsRef(List<Reference> transitionsRef) {
        this.transitionsRef = transitionsRef;
    }

    public List<State> getTransitions() {
        return this.transitions;
    }

    public void setTransitions(List<State> transitions) {
        this.transitions = transitions;
    }

    public Boolean getInitial() {
        return this.initial;
    }

    public void setInitial(Boolean initial) {
        this.initial = initial;
    }

    @Override
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Override
    public OffsetDateTime getLastModifiedAt() {
        return this.lastModifiedAt;
    }

    @Override
    public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
        this.lastModifiedAt = lastModifiedAt;
    }

    @Override
    public Initiator getCreatedBy() {
        return this.createdBy;
    }

    @Override
    public void setCreatedBy(Initiator createdBy) {
        this.createdBy = createdBy;
    }

    @Override
    public Initiator getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    @Override
    public void setLastModifiedBy(Initiator lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public String toString() {
        return "State{id='" + this.id + "',version='" + this.version + "',key='" + this.key + "',type='" + (Object)((Object)this.type) + "',roles='" + this.roles + "',name='" + this.name + "',nameAllLocales='" + this.nameAllLocales + "',description='" + this.description + "',descriptionAllLocales='" + this.descriptionAllLocales + "',builtIn='" + this.builtIn + "',transitionsRef='" + this.transitionsRef + "',transitions='" + this.transitions + "',initial='" + this.initial + "',createdAt='" + this.createdAt + "',lastModifiedAt='" + this.lastModifiedAt + "',createdBy='" + this.createdBy + "',lastModifiedBy='" + this.lastModifiedBy + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        State that = (State)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.version, that.version) && Objects.equals(this.key, that.key) && Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.roles, that.roles) && Objects.equals(this.name, that.name) && Objects.equals(this.nameAllLocales, that.nameAllLocales) && Objects.equals(this.description, that.description) && Objects.equals(this.descriptionAllLocales, that.descriptionAllLocales) && Objects.equals(this.builtIn, that.builtIn) && Objects.equals(this.transitionsRef, that.transitionsRef) && Objects.equals(this.transitions, that.transitions) && Objects.equals(this.initial, that.initial) && Objects.equals(this.createdAt, that.createdAt) && Objects.equals(this.lastModifiedAt, that.lastModifiedAt) && Objects.equals(this.createdBy, that.createdBy) && Objects.equals(this.lastModifiedBy, that.lastModifiedBy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.version, this.key, this.type, this.roles, this.name, this.nameAllLocales, this.description, this.descriptionAllLocales, this.builtIn, this.transitionsRef, this.transitions, this.initial, this.createdAt, this.lastModifiedAt, this.createdBy, this.lastModifiedBy});
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String id;
        private Long version;
        private String key;
        private StateType type;
        private List<StateRole> roles;
        private String name;
        private List<LocalizedString> nameAllLocales;
        private String description;
        private List<LocalizedString> descriptionAllLocales;
        private Boolean builtIn;
        private List<Reference> transitionsRef;
        private List<State> transitions;
        private Boolean initial;
        private OffsetDateTime createdAt;
        private OffsetDateTime lastModifiedAt;
        private Initiator createdBy;
        private Initiator lastModifiedBy;

        public State build() {
            State result = new State();
            result.id = this.id;
            result.version = this.version;
            result.key = this.key;
            result.type = this.type;
            result.roles = this.roles;
            result.name = this.name;
            result.nameAllLocales = this.nameAllLocales;
            result.description = this.description;
            result.descriptionAllLocales = this.descriptionAllLocales;
            result.builtIn = this.builtIn;
            result.transitionsRef = this.transitionsRef;
            result.transitions = this.transitions;
            result.initial = this.initial;
            result.createdAt = this.createdAt;
            result.lastModifiedAt = this.lastModifiedAt;
            result.createdBy = this.createdBy;
            result.lastModifiedBy = this.lastModifiedBy;
            return result;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder version(Long version) {
            this.version = version;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder type(StateType type) {
            this.type = type;
            return this;
        }

        public Builder roles(List<StateRole> roles) {
            this.roles = roles;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder nameAllLocales(List<LocalizedString> nameAllLocales) {
            this.nameAllLocales = nameAllLocales;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder descriptionAllLocales(List<LocalizedString> descriptionAllLocales) {
            this.descriptionAllLocales = descriptionAllLocales;
            return this;
        }

        public Builder builtIn(Boolean builtIn) {
            this.builtIn = builtIn;
            return this;
        }

        public Builder transitionsRef(List<Reference> transitionsRef) {
            this.transitionsRef = transitionsRef;
            return this;
        }

        public Builder transitions(List<State> transitions) {
            this.transitions = transitions;
            return this;
        }

        public Builder initial(Boolean initial) {
            this.initial = initial;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder lastModifiedAt(OffsetDateTime lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public Builder createdBy(Initiator createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public Builder lastModifiedBy(Initiator lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }
    }
}

