/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.Money;
import java.util.Objects;

public class TaxPortion {
    private Double rate;
    private Money amount;
    private String name;

    public TaxPortion() {
    }

    public TaxPortion(Double rate, Money amount, String name) {
        this.rate = rate;
        this.amount = amount;
        this.name = name;
    }

    public Double getRate() {
        return this.rate;
    }

    public void setRate(Double rate) {
        this.rate = rate;
    }

    public Money getAmount() {
        return this.amount;
    }

    public void setAmount(Money amount) {
        this.amount = amount;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "TaxPortion{rate='" + this.rate + "',amount='" + this.amount + "',name='" + this.name + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxPortion that = (TaxPortion)o;
        return Objects.equals(this.rate, that.rate) && Objects.equals(this.amount, that.amount) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.rate, this.amount, this.name);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Double rate;
        private Money amount;
        private String name;

        public TaxPortion build() {
            TaxPortion result = new TaxPortion();
            result.rate = this.rate;
            result.amount = this.amount;
            result.name = this.name;
            return result;
        }

        public Builder rate(Double rate) {
            this.rate = rate;
            return this;
        }

        public Builder amount(Money amount) {
            this.amount = amount;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }
    }
}

