/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import java.util.List;
import java.util.Objects;

public class TreeFilterInput {
    private String path;
    private List<String> rootValues;
    private List<String> subTreeValues;

    public TreeFilterInput() {
    }

    public TreeFilterInput(String path, List<String> rootValues, List<String> subTreeValues) {
        this.path = path;
        this.rootValues = rootValues;
        this.subTreeValues = subTreeValues;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public List<String> getRootValues() {
        return this.rootValues;
    }

    public void setRootValues(List<String> rootValues) {
        this.rootValues = rootValues;
    }

    public List<String> getSubTreeValues() {
        return this.subTreeValues;
    }

    public void setSubTreeValues(List<String> subTreeValues) {
        this.subTreeValues = subTreeValues;
    }

    public String toString() {
        return "TreeFilterInput{path='" + this.path + "',rootValues='" + this.rootValues + "',subTreeValues='" + this.subTreeValues + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreeFilterInput that = (TreeFilterInput)o;
        return Objects.equals(this.path, that.path) && Objects.equals(this.rootValues, that.rootValues) && Objects.equals(this.subTreeValues, that.subTreeValues);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.rootValues, this.subTreeValues);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String path;
        private List<String> rootValues;
        private List<String> subTreeValues;

        public TreeFilterInput build() {
            TreeFilterInput result = new TreeFilterInput();
            result.path = this.path;
            result.rootValues = this.rootValues;
            result.subTreeValues = this.subTreeValues;
            return result;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder rootValues(List<String> rootValues) {
            this.rootValues = rootValues;
            return this;
        }

        public Builder subTreeValues(List<String> subTreeValues) {
            this.subTreeValues = subTreeValues;
            return this;
        }
    }
}

