package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

/**
 * This field gives access to the resources (such as carts) as an associate of a given business unit.
 */
public class AsAssociateGraphQLQuery extends GraphQLQuery {
  public AsAssociateGraphQLQuery(String businessUnitKey, String associateId, String queryName,
      Set<String> fieldsSet) {
    super("query", queryName);
    if (businessUnitKey != null || fieldsSet.contains("businessUnitKey")) {
        getInput().put("businessUnitKey", businessUnitKey);
    }if (associateId != null || fieldsSet.contains("associateId")) {
        getInput().put("associateId", associateId);
    }
  }

  public AsAssociateGraphQLQuery() {
    super("query");
  }

  @Override
  public String getOperationName() {
    return "asAssociate";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private String businessUnitKey;

    private String associateId;

    private String queryName;

    public AsAssociateGraphQLQuery build() {
      return new AsAssociateGraphQLQuery(businessUnitKey, associateId, queryName, fieldsSet);
               
    }

    public Builder businessUnitKey(String businessUnitKey) {
      this.businessUnitKey = businessUnitKey;
      this.fieldsSet.add("businessUnitKey");
      return this;
    }

    public Builder associateId(String associateId) {
      this.associateId = associateId;
      this.fieldsSet.add("associateId");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
