package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.BaseSubProjectionNode;
import java.lang.String;
import java.util.ArrayList;
import java.util.List;

public class AssetProjection<PARENT extends BaseSubProjectionNode<?, ?>, ROOT extends BaseSubProjectionNode<?, ?>> extends BaseSubProjectionNode<PARENT, ROOT> {
  public AssetProjection(PARENT parent, ROOT root) {
    super(parent, root, java.util.Optional.of("Asset"));
  }

  public AssetProjection<PARENT, ROOT> __typename() {
    getFields().put("__typename", null);
    return this;
  }

  public AssetSourceProjection<AssetProjection<PARENT, ROOT>, ROOT> sources() {
     AssetSourceProjection<AssetProjection<PARENT, ROOT>, ROOT> projection = new AssetSourceProjection<>(this, getRoot());
     getFields().put("sources", projection);
     return projection;
  }

  public LocalizedStringProjection<AssetProjection<PARENT, ROOT>, ROOT> nameAllLocales() {
     LocalizedStringProjection<AssetProjection<PARENT, ROOT>, ROOT> projection = new LocalizedStringProjection<>(this, getRoot());
     getFields().put("nameAllLocales", projection);
     return projection;
  }

  public LocalizedStringProjection<AssetProjection<PARENT, ROOT>, ROOT> descriptionAllLocales() {
     LocalizedStringProjection<AssetProjection<PARENT, ROOT>, ROOT> projection = new LocalizedStringProjection<>(this, getRoot());
     getFields().put("descriptionAllLocales", projection);
     return projection;
  }

  public CustomFieldsTypeProjection<AssetProjection<PARENT, ROOT>, ROOT> custom() {
     CustomFieldsTypeProjection<AssetProjection<PARENT, ROOT>, ROOT> projection = new CustomFieldsTypeProjection<>(this, getRoot());
     getFields().put("custom", projection);
     return projection;
  }

  public AssetProjection<PARENT, ROOT> id() {
    getFields().put("id", null);
    return this;
  }

  public AssetProjection<PARENT, ROOT> key() {
    getFields().put("key", null);
    return this;
  }

  public AssetProjection<PARENT, ROOT> name() {
    getFields().put("name", null);
    return this;
  }

  public AssetProjection name(String locale, List<String> acceptLanguage) {
    getFields().put("name", null);
    getInputArguments().computeIfAbsent("name", k -> new ArrayList<>());
    InputArgument localeArg = new InputArgument("locale", locale);
    getInputArguments().get("name").add(localeArg);
    InputArgument acceptLanguageArg = new InputArgument("acceptLanguage", acceptLanguage);
    getInputArguments().get("name").add(acceptLanguageArg);
    return this;
  }

  public AssetProjection<PARENT, ROOT> description() {
    getFields().put("description", null);
    return this;
  }

  public AssetProjection description(String locale, List<String> acceptLanguage) {
    getFields().put("description", null);
    getInputArguments().computeIfAbsent("description", k -> new ArrayList<>());
    InputArgument localeArg = new InputArgument("locale", locale);
    getInputArguments().get("description").add(localeArg);
    InputArgument acceptLanguageArg = new InputArgument("acceptLanguage", acceptLanguage);
    getInputArguments().get("description").add(acceptLanguageArg);
    return this;
  }

  public AssetProjection<PARENT, ROOT> tags() {
    getFields().put("tags", null);
    return this;
  }
}
