package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.BaseSubProjectionNode;
import java.lang.String;
import java.util.ArrayList;
import java.util.List;

public class AttributeGroupProjection<PARENT extends BaseSubProjectionNode<?, ?>, ROOT extends BaseSubProjectionNode<?, ?>> extends BaseSubProjectionNode<PARENT, ROOT> {
  public AttributeGroupProjection(PARENT parent, ROOT root) {
    super(parent, root, java.util.Optional.of("AttributeGroup"));
  }

  public AttributeGroupProjection<PARENT, ROOT> __typename() {
    getFields().put("__typename", null);
    return this;
  }

  public LocalizedStringProjection<AttributeGroupProjection<PARENT, ROOT>, ROOT> nameAllLocales() {
     LocalizedStringProjection<AttributeGroupProjection<PARENT, ROOT>, ROOT> projection = new LocalizedStringProjection<>(this, getRoot());
     getFields().put("nameAllLocales", projection);
     return projection;
  }

  public LocalizedStringProjection<AttributeGroupProjection<PARENT, ROOT>, ROOT> descriptionAllLocales(
      ) {
     LocalizedStringProjection<AttributeGroupProjection<PARENT, ROOT>, ROOT> projection = new LocalizedStringProjection<>(this, getRoot());
     getFields().put("descriptionAllLocales", projection);
     return projection;
  }

  public AttributeReferenceProjection<AttributeGroupProjection<PARENT, ROOT>, ROOT> attributes() {
     AttributeReferenceProjection<AttributeGroupProjection<PARENT, ROOT>, ROOT> projection = new AttributeReferenceProjection<>(this, getRoot());
     getFields().put("attributes", projection);
     return projection;
  }

  public InitiatorProjection<AttributeGroupProjection<PARENT, ROOT>, ROOT> createdBy() {
     InitiatorProjection<AttributeGroupProjection<PARENT, ROOT>, ROOT> projection = new InitiatorProjection<>(this, getRoot());
     getFields().put("createdBy", projection);
     return projection;
  }

  public InitiatorProjection<AttributeGroupProjection<PARENT, ROOT>, ROOT> lastModifiedBy() {
     InitiatorProjection<AttributeGroupProjection<PARENT, ROOT>, ROOT> projection = new InitiatorProjection<>(this, getRoot());
     getFields().put("lastModifiedBy", projection);
     return projection;
  }

  public AttributeGroupProjection<PARENT, ROOT> id() {
    getFields().put("id", null);
    return this;
  }

  public AttributeGroupProjection<PARENT, ROOT> version() {
    getFields().put("version", null);
    return this;
  }

  public AttributeGroupProjection<PARENT, ROOT> createdAt() {
    getFields().put("createdAt", null);
    return this;
  }

  public AttributeGroupProjection<PARENT, ROOT> lastModifiedAt() {
    getFields().put("lastModifiedAt", null);
    return this;
  }

  public AttributeGroupProjection<PARENT, ROOT> name() {
    getFields().put("name", null);
    return this;
  }

  public AttributeGroupProjection name(String locale, List<String> acceptLanguage) {
    getFields().put("name", null);
    getInputArguments().computeIfAbsent("name", k -> new ArrayList<>());
    InputArgument localeArg = new InputArgument("locale", locale);
    getInputArguments().get("name").add(localeArg);
    InputArgument acceptLanguageArg = new InputArgument("acceptLanguage", acceptLanguage);
    getInputArguments().get("name").add(acceptLanguageArg);
    return this;
  }

  public AttributeGroupProjection<PARENT, ROOT> description() {
    getFields().put("description", null);
    return this;
  }

  public AttributeGroupProjection description(String locale, List<String> acceptLanguage) {
    getFields().put("description", null);
    getInputArguments().computeIfAbsent("description", k -> new ArrayList<>());
    InputArgument localeArg = new InputArgument("locale", locale);
    getInputArguments().get("description").add(localeArg);
    InputArgument acceptLanguageArg = new InputArgument("acceptLanguage", acceptLanguage);
    getInputArguments().get("description").add(acceptLanguageArg);
    return this;
  }

  public AttributeGroupProjection<PARENT, ROOT> key() {
    getFields().put("key", null);
    return this;
  }
}
