package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.BaseSubProjectionNode;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;
import java.util.List;

public class ChannelFragmentProjection<PARENT extends BaseSubProjectionNode<?, ?>, ROOT extends BaseSubProjectionNode<?, ?>> extends BaseSubProjectionNode<PARENT, ROOT> {
  {
    getFields().put("__typename", null);
  }

  public ChannelFragmentProjection(PARENT parent, ROOT root) {
    super(parent, root, java.util.Optional.of("Channel"));
  }

  public ChannelFragmentProjection<PARENT, ROOT> __typename() {
    getFields().put("__typename", null);
    return this;
  }

  public ChannelRoleProjection<ChannelFragmentProjection<PARENT, ROOT>, ROOT> roles() {
     ChannelRoleProjection<ChannelFragmentProjection<PARENT, ROOT>, ROOT> projection = new ChannelRoleProjection<>(this, getRoot());
     getFields().put("roles", projection);
     return projection;
  }

  public LocalizedStringProjection<ChannelFragmentProjection<PARENT, ROOT>, ROOT> nameAllLocales() {
     LocalizedStringProjection<ChannelFragmentProjection<PARENT, ROOT>, ROOT> projection = new LocalizedStringProjection<>(this, getRoot());
     getFields().put("nameAllLocales", projection);
     return projection;
  }

  public LocalizedStringProjection<ChannelFragmentProjection<PARENT, ROOT>, ROOT> descriptionAllLocales(
      ) {
     LocalizedStringProjection<ChannelFragmentProjection<PARENT, ROOT>, ROOT> projection = new LocalizedStringProjection<>(this, getRoot());
     getFields().put("descriptionAllLocales", projection);
     return projection;
  }

  public AddressProjection<ChannelFragmentProjection<PARENT, ROOT>, ROOT> address() {
     AddressProjection<ChannelFragmentProjection<PARENT, ROOT>, ROOT> projection = new AddressProjection<>(this, getRoot());
     getFields().put("address", projection);
     return projection;
  }

  public GeometryProjection<ChannelFragmentProjection<PARENT, ROOT>, ROOT> geoLocation() {
     GeometryProjection<ChannelFragmentProjection<PARENT, ROOT>, ROOT> projection = new GeometryProjection<>(this, getRoot());
     getFields().put("geoLocation", projection);
     return projection;
  }

  public ReviewRatingStatisticsProjection<ChannelFragmentProjection<PARENT, ROOT>, ROOT> reviewRatingStatistics(
      ) {
     ReviewRatingStatisticsProjection<ChannelFragmentProjection<PARENT, ROOT>, ROOT> projection = new ReviewRatingStatisticsProjection<>(this, getRoot());
     getFields().put("reviewRatingStatistics", projection);
     return projection;
  }

  public CustomFieldsTypeProjection<ChannelFragmentProjection<PARENT, ROOT>, ROOT> custom() {
     CustomFieldsTypeProjection<ChannelFragmentProjection<PARENT, ROOT>, ROOT> projection = new CustomFieldsTypeProjection<>(this, getRoot());
     getFields().put("custom", projection);
     return projection;
  }

  public InitiatorProjection<ChannelFragmentProjection<PARENT, ROOT>, ROOT> createdBy() {
     InitiatorProjection<ChannelFragmentProjection<PARENT, ROOT>, ROOT> projection = new InitiatorProjection<>(this, getRoot());
     getFields().put("createdBy", projection);
     return projection;
  }

  public InitiatorProjection<ChannelFragmentProjection<PARENT, ROOT>, ROOT> lastModifiedBy() {
     InitiatorProjection<ChannelFragmentProjection<PARENT, ROOT>, ROOT> projection = new InitiatorProjection<>(this, getRoot());
     getFields().put("lastModifiedBy", projection);
     return projection;
  }

  public ChannelFragmentProjection<PARENT, ROOT> id() {
    getFields().put("id", null);
    return this;
  }

  public ChannelFragmentProjection<PARENT, ROOT> version() {
    getFields().put("version", null);
    return this;
  }

  public ChannelFragmentProjection<PARENT, ROOT> key() {
    getFields().put("key", null);
    return this;
  }

  public ChannelFragmentProjection<PARENT, ROOT> name() {
    getFields().put("name", null);
    return this;
  }

  public ChannelFragmentProjection name(String locale, List<String> acceptLanguage) {
    getFields().put("name", null);
    getInputArguments().computeIfAbsent("name", k -> new ArrayList<>());
    InputArgument localeArg = new InputArgument("locale", locale);
    getInputArguments().get("name").add(localeArg);
    InputArgument acceptLanguageArg = new InputArgument("acceptLanguage", acceptLanguage);
    getInputArguments().get("name").add(acceptLanguageArg);
    return this;
  }

  public ChannelFragmentProjection<PARENT, ROOT> description() {
    getFields().put("description", null);
    return this;
  }

  public ChannelFragmentProjection description(String locale, List<String> acceptLanguage) {
    getFields().put("description", null);
    getInputArguments().computeIfAbsent("description", k -> new ArrayList<>());
    InputArgument localeArg = new InputArgument("locale", locale);
    getInputArguments().get("description").add(localeArg);
    InputArgument acceptLanguageArg = new InputArgument("acceptLanguage", acceptLanguage);
    getInputArguments().get("description").add(acceptLanguageArg);
    return this;
  }

  public ChannelFragmentProjection<PARENT, ROOT> createdAt() {
    getFields().put("createdAt", null);
    return this;
  }

  public ChannelFragmentProjection<PARENT, ROOT> lastModifiedAt() {
    getFields().put("lastModifiedAt", null);
    return this;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    builder.append("... on Channel {");
    getFields().forEach((k, v) -> {
        builder.append(" ").append(k);
        if(v != null) {
            builder.append(" ").append(v.toString());
        }
    });
    builder.append("}");
     
    return builder.toString();
  }
}
