package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.BaseSubProjectionNode;
import java.lang.String;
import java.util.ArrayList;
import java.util.List;

public class ChannelProjection<PARENT extends BaseSubProjectionNode<?, ?>, ROOT extends BaseSubProjectionNode<?, ?>> extends BaseSubProjectionNode<PARENT, ROOT> {
  public ChannelProjection(PARENT parent, ROOT root) {
    super(parent, root, java.util.Optional.of("Channel"));
  }

  public ChannelProjection<PARENT, ROOT> __typename() {
    getFields().put("__typename", null);
    return this;
  }

  public ChannelRoleProjection<ChannelProjection<PARENT, ROOT>, ROOT> roles() {
     ChannelRoleProjection<ChannelProjection<PARENT, ROOT>, ROOT> projection = new ChannelRoleProjection<>(this, getRoot());
     getFields().put("roles", projection);
     return projection;
  }

  public LocalizedStringProjection<ChannelProjection<PARENT, ROOT>, ROOT> nameAllLocales() {
     LocalizedStringProjection<ChannelProjection<PARENT, ROOT>, ROOT> projection = new LocalizedStringProjection<>(this, getRoot());
     getFields().put("nameAllLocales", projection);
     return projection;
  }

  public LocalizedStringProjection<ChannelProjection<PARENT, ROOT>, ROOT> descriptionAllLocales() {
     LocalizedStringProjection<ChannelProjection<PARENT, ROOT>, ROOT> projection = new LocalizedStringProjection<>(this, getRoot());
     getFields().put("descriptionAllLocales", projection);
     return projection;
  }

  public AddressProjection<ChannelProjection<PARENT, ROOT>, ROOT> address() {
     AddressProjection<ChannelProjection<PARENT, ROOT>, ROOT> projection = new AddressProjection<>(this, getRoot());
     getFields().put("address", projection);
     return projection;
  }

  public GeometryProjection<ChannelProjection<PARENT, ROOT>, ROOT> geoLocation() {
     GeometryProjection<ChannelProjection<PARENT, ROOT>, ROOT> projection = new GeometryProjection<>(this, getRoot());
     getFields().put("geoLocation", projection);
     return projection;
  }

  public ReviewRatingStatisticsProjection<ChannelProjection<PARENT, ROOT>, ROOT> reviewRatingStatistics(
      ) {
     ReviewRatingStatisticsProjection<ChannelProjection<PARENT, ROOT>, ROOT> projection = new ReviewRatingStatisticsProjection<>(this, getRoot());
     getFields().put("reviewRatingStatistics", projection);
     return projection;
  }

  public CustomFieldsTypeProjection<ChannelProjection<PARENT, ROOT>, ROOT> custom() {
     CustomFieldsTypeProjection<ChannelProjection<PARENT, ROOT>, ROOT> projection = new CustomFieldsTypeProjection<>(this, getRoot());
     getFields().put("custom", projection);
     return projection;
  }

  public InitiatorProjection<ChannelProjection<PARENT, ROOT>, ROOT> createdBy() {
     InitiatorProjection<ChannelProjection<PARENT, ROOT>, ROOT> projection = new InitiatorProjection<>(this, getRoot());
     getFields().put("createdBy", projection);
     return projection;
  }

  public InitiatorProjection<ChannelProjection<PARENT, ROOT>, ROOT> lastModifiedBy() {
     InitiatorProjection<ChannelProjection<PARENT, ROOT>, ROOT> projection = new InitiatorProjection<>(this, getRoot());
     getFields().put("lastModifiedBy", projection);
     return projection;
  }

  public ChannelProjection<PARENT, ROOT> id() {
    getFields().put("id", null);
    return this;
  }

  public ChannelProjection<PARENT, ROOT> version() {
    getFields().put("version", null);
    return this;
  }

  public ChannelProjection<PARENT, ROOT> key() {
    getFields().put("key", null);
    return this;
  }

  public ChannelProjection<PARENT, ROOT> name() {
    getFields().put("name", null);
    return this;
  }

  public ChannelProjection name(String locale, List<String> acceptLanguage) {
    getFields().put("name", null);
    getInputArguments().computeIfAbsent("name", k -> new ArrayList<>());
    InputArgument localeArg = new InputArgument("locale", locale);
    getInputArguments().get("name").add(localeArg);
    InputArgument acceptLanguageArg = new InputArgument("acceptLanguage", acceptLanguage);
    getInputArguments().get("name").add(acceptLanguageArg);
    return this;
  }

  public ChannelProjection<PARENT, ROOT> description() {
    getFields().put("description", null);
    return this;
  }

  public ChannelProjection description(String locale, List<String> acceptLanguage) {
    getFields().put("description", null);
    getInputArguments().computeIfAbsent("description", k -> new ArrayList<>());
    InputArgument localeArg = new InputArgument("locale", locale);
    getInputArguments().get("description").add(localeArg);
    InputArgument acceptLanguageArg = new InputArgument("acceptLanguage", acceptLanguage);
    getInputArguments().get("description").add(acceptLanguageArg);
    return this;
  }

  public ChannelProjection<PARENT, ROOT> createdAt() {
    getFields().put("createdAt", null);
    return this;
  }

  public ChannelProjection<PARENT, ROOT> lastModifiedAt() {
    getFields().put("lastModifiedAt", null);
    return this;
  }
}
