package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.ApprovalRuleDraft;
import com.commercetools.graphql.api.types.AsAssociateArgument;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class CreateApprovalRuleGraphQLQuery extends GraphQLQuery {
  public CreateApprovalRuleGraphQLQuery(ApprovalRuleDraft draft, AsAssociateArgument asAssociate,
      String queryName, Set<String> fieldsSet) {
    super("mutation", queryName);
    if (draft != null || fieldsSet.contains("draft")) {
        getInput().put("draft", draft);
    }if (asAssociate != null || fieldsSet.contains("asAssociate")) {
        getInput().put("asAssociate", asAssociate);
    }
  }

  public CreateApprovalRuleGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "createApprovalRule";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private ApprovalRuleDraft draft;

    private AsAssociateArgument asAssociate;

    private String queryName;

    public CreateApprovalRuleGraphQLQuery build() {
      return new CreateApprovalRuleGraphQLQuery(draft, asAssociate, queryName, fieldsSet);
               
    }

    public Builder draft(ApprovalRuleDraft draft) {
      this.draft = draft;
      this.fieldsSet.add("draft");
      return this;
    }

    /**
     * Create/modify entity as an associate in business-unit.
     */
    public Builder asAssociate(AsAssociateArgument asAssociate) {
      this.asAssociate = asAssociate;
      this.fieldsSet.add("asAssociate");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
