package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.AssociateRoleDraft;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class CreateAssociateRoleGraphQLQuery extends GraphQLQuery {
  public CreateAssociateRoleGraphQLQuery(AssociateRoleDraft draft, String queryName,
      Set<String> fieldsSet) {
    super("mutation", queryName);
    if (draft != null || fieldsSet.contains("draft")) {
        getInput().put("draft", draft);
    }
  }

  public CreateAssociateRoleGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "createAssociateRole";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private AssociateRoleDraft draft;

    private String queryName;

    public CreateAssociateRoleGraphQLQuery build() {
      return new CreateAssociateRoleGraphQLQuery(draft, queryName, fieldsSet);
               
    }

    public Builder draft(AssociateRoleDraft draft) {
      this.draft = draft;
      this.fieldsSet.add("draft");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
