package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.ChannelDraft;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class CreateChannelGraphQLQuery extends GraphQLQuery {
  public CreateChannelGraphQLQuery(ChannelDraft draft, String queryName, Set<String> fieldsSet) {
    super("mutation", queryName);
    if (draft != null || fieldsSet.contains("draft")) {
        getInput().put("draft", draft);
    }
  }

  public CreateChannelGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "createChannel";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private ChannelDraft draft;

    private String queryName;

    public CreateChannelGraphQLQuery build() {
      return new CreateChannelGraphQLQuery(draft, queryName, fieldsSet);
               
    }

    public Builder draft(ChannelDraft draft) {
      this.draft = draft;
      this.fieldsSet.add("draft");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
