package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.MyBusinessUnitDraft;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class CreateMyBusinessUnitGraphQLQuery extends GraphQLQuery {
  public CreateMyBusinessUnitGraphQLQuery(MyBusinessUnitDraft draft, String queryName,
      Set<String> fieldsSet) {
    super("mutation", queryName);
    if (draft != null || fieldsSet.contains("draft")) {
        getInput().put("draft", draft);
    }
  }

  public CreateMyBusinessUnitGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "createMyBusinessUnit";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private MyBusinessUnitDraft draft;

    private String queryName;

    public CreateMyBusinessUnitGraphQLQuery build() {
      return new CreateMyBusinessUnitGraphQLQuery(draft, queryName, fieldsSet);
               
    }

    public Builder draft(MyBusinessUnitDraft draft) {
      this.draft = draft;
      this.fieldsSet.add("draft");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
