package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.OrderMyQuoteCommand;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

/**
 * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
 */
public class CreateMyOrderFromQuoteGraphQLQuery extends GraphQLQuery {
  public CreateMyOrderFromQuoteGraphQLQuery(OrderMyQuoteCommand draft, String queryName,
      Set<String> fieldsSet) {
    super("mutation", queryName);
    if (draft != null || fieldsSet.contains("draft")) {
        getInput().put("draft", draft);
    }
  }

  public CreateMyOrderFromQuoteGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "createMyOrderFromQuote";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private OrderMyQuoteCommand draft;

    private String queryName;

    public CreateMyOrderFromQuoteGraphQLQuery build() {
      return new CreateMyOrderFromQuoteGraphQLQuery(draft, queryName, fieldsSet);
               
    }

    public Builder draft(OrderMyQuoteCommand draft) {
      this.draft = draft;
      this.fieldsSet.add("draft");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
