package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.MyQuoteRequestDraft;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class CreateMyQuoteRequestGraphQLQuery extends GraphQLQuery {
  public CreateMyQuoteRequestGraphQLQuery(MyQuoteRequestDraft draft, String queryName,
      Set<String> fieldsSet) {
    super("mutation", queryName);
    if (draft != null || fieldsSet.contains("draft")) {
        getInput().put("draft", draft);
    }
  }

  public CreateMyQuoteRequestGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "createMyQuoteRequest";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private MyQuoteRequestDraft draft;

    private String queryName;

    public CreateMyQuoteRequestGraphQLQuery build() {
      return new CreateMyQuoteRequestGraphQLQuery(draft, queryName, fieldsSet);
               
    }

    public Builder draft(MyQuoteRequestDraft draft) {
      this.draft = draft;
      this.fieldsSet.add("draft");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
