package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.CustomObjectDraft;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class CreateOrUpdateCustomObjectGraphQLQuery extends GraphQLQuery {
  public CreateOrUpdateCustomObjectGraphQLQuery(CustomObjectDraft draft, String queryName,
      Set<String> fieldsSet) {
    super("mutation", queryName);
    if (draft != null || fieldsSet.contains("draft")) {
        getInput().put("draft", draft);
    }
  }

  public CreateOrUpdateCustomObjectGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "createOrUpdateCustomObject";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private CustomObjectDraft draft;

    private String queryName;

    public CreateOrUpdateCustomObjectGraphQLQuery build() {
      return new CreateOrUpdateCustomObjectGraphQLQuery(draft, queryName, fieldsSet);
               
    }

    public Builder draft(CustomObjectDraft draft) {
      this.draft = draft;
      this.fieldsSet.add("draft");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
