package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.OrderEditDraft;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class CreateOrderEditGraphQLQuery extends GraphQLQuery {
  public CreateOrderEditGraphQLQuery(OrderEditDraft draft, String queryName,
      Set<String> fieldsSet) {
    super("mutation", queryName);
    if (draft != null || fieldsSet.contains("draft")) {
        getInput().put("draft", draft);
    }
  }

  public CreateOrderEditGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "createOrderEdit";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private OrderEditDraft draft;

    private String queryName;

    public CreateOrderEditGraphQLQuery build() {
      return new CreateOrderEditGraphQLQuery(draft, queryName, fieldsSet);
               
    }

    public Builder draft(OrderEditDraft draft) {
      this.draft = draft;
      this.fieldsSet.add("draft");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
