package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.AsAssociateArgument;
import com.commercetools.graphql.api.types.OrderCartCommand;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class CreateOrderFromCartGraphQLQuery extends GraphQLQuery {
  public CreateOrderFromCartGraphQLQuery(OrderCartCommand draft, String storeKey,
      AsAssociateArgument asAssociate, String queryName, Set<String> fieldsSet) {
    super("mutation", queryName);
    if (draft != null || fieldsSet.contains("draft")) {
        getInput().put("draft", draft);
    }if (storeKey != null || fieldsSet.contains("storeKey")) {
        getInput().put("storeKey", storeKey);
    }if (asAssociate != null || fieldsSet.contains("asAssociate")) {
        getInput().put("asAssociate", asAssociate);
    }
  }

  public CreateOrderFromCartGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "createOrderFromCart";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private OrderCartCommand draft;

    private String storeKey;

    private AsAssociateArgument asAssociate;

    private String queryName;

    public CreateOrderFromCartGraphQLQuery build() {
      return new CreateOrderFromCartGraphQLQuery(draft, storeKey, asAssociate, queryName, fieldsSet);
               
    }

    public Builder draft(OrderCartCommand draft) {
      this.draft = draft;
      this.fieldsSet.add("draft");
      return this;
    }

    /**
     * The mutation is only performed if the resource is part of the store. Can be used with store-specific OAuth permissions.
     */
    public Builder storeKey(String storeKey) {
      this.storeKey = storeKey;
      this.fieldsSet.add("storeKey");
      return this;
    }

    /**
     * Create/modify entity as an associate in business-unit.
     */
    public Builder asAssociate(AsAssociateArgument asAssociate) {
      this.asAssociate = asAssociate;
      this.fieldsSet.add("asAssociate");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
