package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.CreateProductSelectionDraft;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class CreateProductSelectionGraphQLQuery extends GraphQLQuery {
  public CreateProductSelectionGraphQLQuery(CreateProductSelectionDraft draft, String queryName,
      Set<String> fieldsSet) {
    super("mutation", queryName);
    if (draft != null || fieldsSet.contains("draft")) {
        getInput().put("draft", draft);
    }
  }

  public CreateProductSelectionGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "createProductSelection";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private CreateProductSelectionDraft draft;

    private String queryName;

    public CreateProductSelectionGraphQLQuery build() {
      return new CreateProductSelectionGraphQLQuery(draft, queryName, fieldsSet);
               
    }

    public Builder draft(CreateProductSelectionDraft draft) {
      this.draft = draft;
      this.fieldsSet.add("draft");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
