package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.ProductTypeDraft;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class CreateProductTypeGraphQLQuery extends GraphQLQuery {
  public CreateProductTypeGraphQLQuery(ProductTypeDraft draft, String queryName,
      Set<String> fieldsSet) {
    super("mutation", queryName);
    if (draft != null || fieldsSet.contains("draft")) {
        getInput().put("draft", draft);
    }
  }

  public CreateProductTypeGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "createProductType";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private ProductTypeDraft draft;

    private String queryName;

    public CreateProductTypeGraphQLQuery build() {
      return new CreateProductTypeGraphQLQuery(draft, queryName, fieldsSet);
               
    }

    public Builder draft(ProductTypeDraft draft) {
      this.draft = draft;
      this.fieldsSet.add("draft");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
