package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.ReviewDraft;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class CreateReviewGraphQLQuery extends GraphQLQuery {
  public CreateReviewGraphQLQuery(ReviewDraft draft, String queryName, Set<String> fieldsSet) {
    super("mutation", queryName);
    if (draft != null || fieldsSet.contains("draft")) {
        getInput().put("draft", draft);
    }
  }

  public CreateReviewGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "createReview";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private ReviewDraft draft;

    private String queryName;

    public CreateReviewGraphQLQuery build() {
      return new CreateReviewGraphQLQuery(draft, queryName, fieldsSet);
               
    }

    public Builder draft(ReviewDraft draft) {
      this.draft = draft;
      this.fieldsSet.add("draft");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
