package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.StateDraft;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class CreateStateGraphQLQuery extends GraphQLQuery {
  public CreateStateGraphQLQuery(StateDraft draft, String queryName, Set<String> fieldsSet) {
    super("mutation", queryName);
    if (draft != null || fieldsSet.contains("draft")) {
        getInput().put("draft", draft);
    }
  }

  public CreateStateGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "createState";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private StateDraft draft;

    private String queryName;

    public CreateStateGraphQLQuery build() {
      return new CreateStateGraphQLQuery(draft, queryName, fieldsSet);
               
    }

    public Builder draft(StateDraft draft) {
      this.draft = draft;
      this.fieldsSet.add("draft");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
