package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.SubscriptionDraft;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class CreateSubscriptionGraphQLQuery extends GraphQLQuery {
  public CreateSubscriptionGraphQLQuery(SubscriptionDraft draft, String queryName,
      Set<String> fieldsSet) {
    super("mutation", queryName);
    if (draft != null || fieldsSet.contains("draft")) {
        getInput().put("draft", draft);
    }
  }

  public CreateSubscriptionGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "createSubscription";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private SubscriptionDraft draft;

    private String queryName;

    public CreateSubscriptionGraphQLQuery build() {
      return new CreateSubscriptionGraphQLQuery(draft, queryName, fieldsSet);
               
    }

    public Builder draft(SubscriptionDraft draft) {
      this.draft = draft;
      this.fieldsSet.add("draft");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
