package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.TaxCategoryDraft;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class CreateTaxCategoryGraphQLQuery extends GraphQLQuery {
  public CreateTaxCategoryGraphQLQuery(TaxCategoryDraft draft, String queryName,
      Set<String> fieldsSet) {
    super("mutation", queryName);
    if (draft != null || fieldsSet.contains("draft")) {
        getInput().put("draft", draft);
    }
  }

  public CreateTaxCategoryGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "createTaxCategory";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private TaxCategoryDraft draft;

    private String queryName;

    public CreateTaxCategoryGraphQLQuery build() {
      return new CreateTaxCategoryGraphQLQuery(draft, queryName, fieldsSet);
               
    }

    public Builder draft(TaxCategoryDraft draft) {
      this.draft = draft;
      this.fieldsSet.add("draft");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
