package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.BaseSubProjectionNode;
import java.lang.String;
import java.util.ArrayList;
import java.util.List;

public class CustomFieldsTypeProjection<PARENT extends BaseSubProjectionNode<?, ?>, ROOT extends BaseSubProjectionNode<?, ?>> extends BaseSubProjectionNode<PARENT, ROOT> {
  public CustomFieldsTypeProjection(PARENT parent, ROOT root) {
    super(parent, root, java.util.Optional.of("CustomFieldsType"));
  }

  public CustomFieldsTypeProjection<PARENT, ROOT> __typename() {
    getFields().put("__typename", null);
    return this;
  }

  public ReferenceProjection<CustomFieldsTypeProjection<PARENT, ROOT>, ROOT> typeRef() {
     ReferenceProjection<CustomFieldsTypeProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("typeRef", projection);
     return projection;
  }

  public TypeDefinitionProjection<CustomFieldsTypeProjection<PARENT, ROOT>, ROOT> type() {
     TypeDefinitionProjection<CustomFieldsTypeProjection<PARENT, ROOT>, ROOT> projection = new TypeDefinitionProjection<>(this, getRoot());
     getFields().put("type", projection);
     return projection;
  }

  public RawCustomFieldProjection<CustomFieldsTypeProjection<PARENT, ROOT>, ROOT> customFieldsRaw(
      ) {
     RawCustomFieldProjection<CustomFieldsTypeProjection<PARENT, ROOT>, ROOT> projection = new RawCustomFieldProjection<>(this, getRoot());
     getFields().put("customFieldsRaw", projection);
     return projection;
  }

  public RawCustomFieldProjection<CustomFieldsTypeProjection<PARENT, ROOT>, ROOT> customFieldsRaw(
      List<String> includeNames, List<String> excludeNames) {
    RawCustomFieldProjection<CustomFieldsTypeProjection<PARENT, ROOT>, ROOT> projection = new RawCustomFieldProjection<>(this, getRoot());    
    getFields().put("customFieldsRaw", projection);
    getInputArguments().computeIfAbsent("customFieldsRaw", k -> new ArrayList<>());                      
    InputArgument includeNamesArg = new InputArgument("includeNames", includeNames);
    getInputArguments().get("customFieldsRaw").add(includeNamesArg);
    InputArgument excludeNamesArg = new InputArgument("excludeNames", excludeNames);
    getInputArguments().get("customFieldsRaw").add(excludeNamesArg);
    return projection;
  }
}
