package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class CustomerGraphQLQuery extends GraphQLQuery {
  public CustomerGraphQLQuery(String emailToken, String passwordToken, String id, String key,
      String queryName, Set<String> fieldsSet) {
    super("query", queryName);
    if (emailToken != null || fieldsSet.contains("emailToken")) {
        getInput().put("emailToken", emailToken);
    }if (passwordToken != null || fieldsSet.contains("passwordToken")) {
        getInput().put("passwordToken", passwordToken);
    }if (id != null || fieldsSet.contains("id")) {
        getInput().put("id", id);
    }if (key != null || fieldsSet.contains("key")) {
        getInput().put("key", key);
    }
  }

  public CustomerGraphQLQuery() {
    super("query");
  }

  @Override
  public String getOperationName() {
    return "customer";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private String emailToken;

    private String passwordToken;

    private String id;

    private String key;

    private String queryName;

    public CustomerGraphQLQuery build() {
      return new CustomerGraphQLQuery(emailToken, passwordToken, id, key, queryName, fieldsSet);
               
    }

    /**
     * Queries a customer with specified email token
     */
    public Builder emailToken(String emailToken) {
      this.emailToken = emailToken;
      this.fieldsSet.add("emailToken");
      return this;
    }

    /**
     * Queries a customer with specified password token
     */
    public Builder passwordToken(String passwordToken) {
      this.passwordToken = passwordToken;
      this.fieldsSet.add("passwordToken");
      return this;
    }

    /**
     * Queries with specified ID
     */
    public Builder id(String id) {
      this.id = id;
      this.fieldsSet.add("id");
      return this;
    }

    /**
     * Queries with specified key
     */
    public Builder key(String key) {
      this.key = key;
      this.fieldsSet.add("key");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
