package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.CustomerSignMeInDraft;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

/**
 * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
 *
 * Retrieves the authenticated customer (a customer that matches the given email/password pair).
 *
 * If used with an access token for Anonymous Sessions, all orders and carts belonging to the `anonymousId` will be assigned to the newly created customer.
 *
 * * If the customer does not have a cart yet, the anonymous cart that was modified most recently becomes the customer's cart.
 * * If the customer already has a cart, the most recently modified anonymous cart will be handled according to the `AnonymousCartSignInMode`.
 *
 * If a cart is is returned as part of the `CustomerSignInResult`, it has been recalculated (it will have up-to-date prices, taxes and discounts, and invalid line items have been removed).
 */
public class CustomerSignMeInGraphQLQuery extends GraphQLQuery {
  public CustomerSignMeInGraphQLQuery(CustomerSignMeInDraft draft, String storeKey,
      String queryName, Set<String> fieldsSet) {
    super("mutation", queryName);
    if (draft != null || fieldsSet.contains("draft")) {
        getInput().put("draft", draft);
    }if (storeKey != null || fieldsSet.contains("storeKey")) {
        getInput().put("storeKey", storeKey);
    }
  }

  public CustomerSignMeInGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "customerSignMeIn";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private CustomerSignMeInDraft draft;

    private String storeKey;

    private String queryName;

    public CustomerSignMeInGraphQLQuery build() {
      return new CustomerSignMeInGraphQLQuery(draft, storeKey, queryName, fieldsSet);
               
    }

    public Builder draft(CustomerSignMeInDraft draft) {
      this.draft = draft;
      this.fieldsSet.add("draft");
      return this;
    }

    /**
     * The mutation is only performed if the resource is part of the store. Can be used with store-specific OAuth permissions.
     */
    public Builder storeKey(String storeKey) {
      this.storeKey = storeKey;
      this.fieldsSet.add("storeKey");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
