package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.CustomerSignUpDraft;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

/**
 * Creates a customer. If an anonymous cart is given then the cart is assigned to the created customer and the version number of the Cart will increase. If the id of an anonymous session is given, all carts and orders will be assigned to the created customer.
 */
public class CustomerSignUpGraphQLQuery extends GraphQLQuery {
  public CustomerSignUpGraphQLQuery(CustomerSignUpDraft draft, String storeKey, String queryName,
      Set<String> fieldsSet) {
    super("mutation", queryName);
    if (draft != null || fieldsSet.contains("draft")) {
        getInput().put("draft", draft);
    }if (storeKey != null || fieldsSet.contains("storeKey")) {
        getInput().put("storeKey", storeKey);
    }
  }

  public CustomerSignUpGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "customerSignUp";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private CustomerSignUpDraft draft;

    private String storeKey;

    private String queryName;

    public CustomerSignUpGraphQLQuery build() {
      return new CustomerSignUpGraphQLQuery(draft, storeKey, queryName, fieldsSet);
               
    }

    public Builder draft(CustomerSignUpDraft draft) {
      this.draft = draft;
      this.fieldsSet.add("draft");
      return this;
    }

    /**
     * The mutation is only performed if the resource is part of the store. Can be used with store-specific OAuth permissions.
     */
    public Builder storeKey(String storeKey) {
      this.storeKey = storeKey;
      this.fieldsSet.add("storeKey");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
