package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class DeleteCustomObjectGraphQLQuery extends GraphQLQuery {
  public DeleteCustomObjectGraphQLQuery(Long version, String id, String key, String container,
      Boolean personalDataErasure, String queryName, Set<String> fieldsSet) {
    super("mutation", queryName);
    if (version != null || fieldsSet.contains("version")) {
        getInput().put("version", version);
    }if (id != null || fieldsSet.contains("id")) {
        getInput().put("id", id);
    }if (key != null || fieldsSet.contains("key")) {
        getInput().put("key", key);
    }if (container != null || fieldsSet.contains("container")) {
        getInput().put("container", container);
    }if (personalDataErasure != null || fieldsSet.contains("personalDataErasure")) {
        getInput().put("personalDataErasure", personalDataErasure);
    }
  }

  public DeleteCustomObjectGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "deleteCustomObject";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private Long version;

    private String id;

    private String key;

    private String container;

    private Boolean personalDataErasure;

    private String queryName;

    public DeleteCustomObjectGraphQLQuery build() {
      return new DeleteCustomObjectGraphQLQuery(version, id, key, container, personalDataErasure, queryName, fieldsSet);
               
    }

    public Builder version(Long version) {
      this.version = version;
      this.fieldsSet.add("version");
      return this;
    }

    /**
     * Queries with specified ID
     */
    public Builder id(String id) {
      this.id = id;
      this.fieldsSet.add("id");
      return this;
    }

    /**
     * Queries with specified key
     */
    public Builder key(String key) {
      this.key = key;
      this.fieldsSet.add("key");
      return this;
    }

    public Builder container(String container) {
      this.container = container;
      this.fieldsSet.add("container");
      return this;
    }

    public Builder personalDataErasure(Boolean personalDataErasure) {
      this.personalDataErasure = personalDataErasure;
      this.fieldsSet.add("personalDataErasure");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
