package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class DeleteMyPaymentGraphQLQuery extends GraphQLQuery {
  public DeleteMyPaymentGraphQLQuery(String id, Long version, String queryName,
      Set<String> fieldsSet) {
    super("mutation", queryName);
    if (id != null || fieldsSet.contains("id")) {
        getInput().put("id", id);
    }if (version != null || fieldsSet.contains("version")) {
        getInput().put("version", version);
    }
  }

  public DeleteMyPaymentGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "deleteMyPayment";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private String id;

    private Long version;

    private String queryName;

    public DeleteMyPaymentGraphQLQuery build() {
      return new DeleteMyPaymentGraphQLQuery(id, version, queryName, fieldsSet);
               
    }

    public Builder id(String id) {
      this.id = id;
      this.fieldsSet.add("id");
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      this.fieldsSet.add("version");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
