package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.ImportOrderDraft;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class ImportOrderGraphQLQuery extends GraphQLQuery {
  public ImportOrderGraphQLQuery(ImportOrderDraft draft, String queryName, Set<String> fieldsSet) {
    super("mutation", queryName);
    if (draft != null || fieldsSet.contains("draft")) {
        getInput().put("draft", draft);
    }
  }

  public ImportOrderGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "importOrder";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private ImportOrderDraft draft;

    private String queryName;

    public ImportOrderGraphQLQuery build() {
      return new ImportOrderGraphQLQuery(draft, queryName, fieldsSet);
               
    }

    public Builder draft(ImportOrderDraft draft) {
      this.draft = draft;
      this.fieldsSet.add("draft");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
