package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

/**
 * This field gives access to the resources (such as carts) that are inside the given store.
 */
public class InStoreGraphQLQuery extends GraphQLQuery {
  public InStoreGraphQLQuery(String key, String queryName, Set<String> fieldsSet) {
    super("query", queryName);
    if (key != null || fieldsSet.contains("key")) {
        getInput().put("key", key);
    }
  }

  public InStoreGraphQLQuery() {
    super("query");
  }

  @Override
  public String getOperationName() {
    return "inStore";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private String key;

    private String queryName;

    public InStoreGraphQLQuery build() {
      return new InStoreGraphQLQuery(key, queryName, fieldsSet);
               
    }

    public Builder key(String key) {
      this.key = key;
      this.fieldsSet.add("key");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
