package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.BaseSubProjectionNode;
import java.lang.Integer;
import java.lang.String;
import java.util.ArrayList;
import java.util.List;

public class InStoreMeProjection<PARENT extends BaseSubProjectionNode<?, ?>, ROOT extends BaseSubProjectionNode<?, ?>> extends BaseSubProjectionNode<PARENT, ROOT> {
  public InStoreMeProjection(PARENT parent, ROOT root) {
    super(parent, root, java.util.Optional.of("InStoreMe"));
  }

  public InStoreMeProjection<PARENT, ROOT> __typename() {
    getFields().put("__typename", null);
    return this;
  }

  public CustomerProjection<InStoreMeProjection<PARENT, ROOT>, ROOT> customer() {
     CustomerProjection<InStoreMeProjection<PARENT, ROOT>, ROOT> projection = new CustomerProjection<>(this, getRoot());
     getFields().put("customer", projection);
     return projection;
  }

  public CartProjection<InStoreMeProjection<PARENT, ROOT>, ROOT> cart() {
     CartProjection<InStoreMeProjection<PARENT, ROOT>, ROOT> projection = new CartProjection<>(this, getRoot());
     getFields().put("cart", projection);
     return projection;
  }

  public CartProjection<InStoreMeProjection<PARENT, ROOT>, ROOT> cart(String id) {
    CartProjection<InStoreMeProjection<PARENT, ROOT>, ROOT> projection = new CartProjection<>(this, getRoot());    
    getFields().put("cart", projection);
    getInputArguments().computeIfAbsent("cart", k -> new ArrayList<>());                      
    InputArgument idArg = new InputArgument("id", id);
    getInputArguments().get("cart").add(idArg);
    return projection;
  }

  public CartQueryResultProjection<InStoreMeProjection<PARENT, ROOT>, ROOT> carts() {
     CartQueryResultProjection<InStoreMeProjection<PARENT, ROOT>, ROOT> projection = new CartQueryResultProjection<>(this, getRoot());
     getFields().put("carts", projection);
     return projection;
  }

  public CartQueryResultProjection<InStoreMeProjection<PARENT, ROOT>, ROOT> carts(String where,
      List<String> sort, Integer limit, Integer offset) {
    CartQueryResultProjection<InStoreMeProjection<PARENT, ROOT>, ROOT> projection = new CartQueryResultProjection<>(this, getRoot());    
    getFields().put("carts", projection);
    getInputArguments().computeIfAbsent("carts", k -> new ArrayList<>());                      
    InputArgument whereArg = new InputArgument("where", where);
    getInputArguments().get("carts").add(whereArg);
    InputArgument sortArg = new InputArgument("sort", sort);
    getInputArguments().get("carts").add(sortArg);
    InputArgument limitArg = new InputArgument("limit", limit);
    getInputArguments().get("carts").add(limitArg);
    InputArgument offsetArg = new InputArgument("offset", offset);
    getInputArguments().get("carts").add(offsetArg);
    return projection;
  }

  public CartProjection<InStoreMeProjection<PARENT, ROOT>, ROOT> activeCart() {
     CartProjection<InStoreMeProjection<PARENT, ROOT>, ROOT> projection = new CartProjection<>(this, getRoot());
     getFields().put("activeCart", projection);
     return projection;
  }

  public OrderProjection<InStoreMeProjection<PARENT, ROOT>, ROOT> order() {
     OrderProjection<InStoreMeProjection<PARENT, ROOT>, ROOT> projection = new OrderProjection<>(this, getRoot());
     getFields().put("order", projection);
     return projection;
  }

  public OrderProjection<InStoreMeProjection<PARENT, ROOT>, ROOT> order(String id,
      String orderNumber) {
    OrderProjection<InStoreMeProjection<PARENT, ROOT>, ROOT> projection = new OrderProjection<>(this, getRoot());    
    getFields().put("order", projection);
    getInputArguments().computeIfAbsent("order", k -> new ArrayList<>());                      
    InputArgument idArg = new InputArgument("id", id);
    getInputArguments().get("order").add(idArg);
    InputArgument orderNumberArg = new InputArgument("orderNumber", orderNumber);
    getInputArguments().get("order").add(orderNumberArg);
    return projection;
  }

  public OrderQueryResultProjection<InStoreMeProjection<PARENT, ROOT>, ROOT> orders() {
     OrderQueryResultProjection<InStoreMeProjection<PARENT, ROOT>, ROOT> projection = new OrderQueryResultProjection<>(this, getRoot());
     getFields().put("orders", projection);
     return projection;
  }

  public OrderQueryResultProjection<InStoreMeProjection<PARENT, ROOT>, ROOT> orders(String where,
      List<String> sort, Integer limit, Integer offset) {
    OrderQueryResultProjection<InStoreMeProjection<PARENT, ROOT>, ROOT> projection = new OrderQueryResultProjection<>(this, getRoot());    
    getFields().put("orders", projection);
    getInputArguments().computeIfAbsent("orders", k -> new ArrayList<>());                      
    InputArgument whereArg = new InputArgument("where", where);
    getInputArguments().get("orders").add(whereArg);
    InputArgument sortArg = new InputArgument("sort", sort);
    getInputArguments().get("orders").add(sortArg);
    InputArgument limitArg = new InputArgument("limit", limit);
    getInputArguments().get("orders").add(limitArg);
    InputArgument offsetArg = new InputArgument("offset", offset);
    getInputArguments().get("orders").add(offsetArg);
    return projection;
  }

  public ShoppingListProjection<InStoreMeProjection<PARENT, ROOT>, ROOT> shoppingList() {
     ShoppingListProjection<InStoreMeProjection<PARENT, ROOT>, ROOT> projection = new ShoppingListProjection<>(this, getRoot());
     getFields().put("shoppingList", projection);
     return projection;
  }

  public ShoppingListProjection<InStoreMeProjection<PARENT, ROOT>, ROOT> shoppingList(String id,
      String key) {
    ShoppingListProjection<InStoreMeProjection<PARENT, ROOT>, ROOT> projection = new ShoppingListProjection<>(this, getRoot());    
    getFields().put("shoppingList", projection);
    getInputArguments().computeIfAbsent("shoppingList", k -> new ArrayList<>());                      
    InputArgument idArg = new InputArgument("id", id);
    getInputArguments().get("shoppingList").add(idArg);
    InputArgument keyArg = new InputArgument("key", key);
    getInputArguments().get("shoppingList").add(keyArg);
    return projection;
  }

  public ShoppingListQueryResultProjection<InStoreMeProjection<PARENT, ROOT>, ROOT> shoppingLists(
      ) {
     ShoppingListQueryResultProjection<InStoreMeProjection<PARENT, ROOT>, ROOT> projection = new ShoppingListQueryResultProjection<>(this, getRoot());
     getFields().put("shoppingLists", projection);
     return projection;
  }

  public ShoppingListQueryResultProjection<InStoreMeProjection<PARENT, ROOT>, ROOT> shoppingLists(
      String where, List<String> sort, Integer limit, Integer offset) {
    ShoppingListQueryResultProjection<InStoreMeProjection<PARENT, ROOT>, ROOT> projection = new ShoppingListQueryResultProjection<>(this, getRoot());    
    getFields().put("shoppingLists", projection);
    getInputArguments().computeIfAbsent("shoppingLists", k -> new ArrayList<>());                      
    InputArgument whereArg = new InputArgument("where", where);
    getInputArguments().get("shoppingLists").add(whereArg);
    InputArgument sortArg = new InputArgument("sort", sort);
    getInputArguments().get("shoppingLists").add(sortArg);
    InputArgument limitArg = new InputArgument("limit", limit);
    getInputArguments().get("shoppingLists").add(limitArg);
    InputArgument offsetArg = new InputArgument("offset", offset);
    getInputArguments().get("shoppingLists").add(offsetArg);
    return projection;
  }
}
