package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.BaseSubProjectionNode;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.ArrayList;
import java.util.List;

public class InStoreProjectionRoot<PARENT extends BaseSubProjectionNode<?, ?>, ROOT extends BaseSubProjectionNode<?, ?>> extends BaseSubProjectionNode<PARENT, ROOT> {
  public InStoreProjectionRoot() {
    super(null, null, java.util.Optional.of("InStore"));
  }

  public InStoreProjectionRoot<PARENT, ROOT> __typename() {
    getFields().put("__typename", null);
    return this;
  }

  public InStoreMeProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> me(
      ) {
    InStoreMeProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new InStoreMeProjection<>(this, this);    
    getFields().put("me", projection);
    return projection;
  }

  public ShippingMethodProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> shippingMethodsByCart(
      ) {
    ShippingMethodProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new ShippingMethodProjection<>(this, this);    
    getFields().put("shippingMethodsByCart", projection);
    return projection;
  }

  public ShippingMethodProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> shippingMethodsByCart(
      String id) {
    ShippingMethodProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new ShippingMethodProjection<>(this, this);    
    getFields().put("shippingMethodsByCart", projection);
    getInputArguments().computeIfAbsent("shippingMethodsByCart", k -> new ArrayList<>());                      
    InputArgument idArg = new InputArgument("id", id);
    getInputArguments().get("shippingMethodsByCart").add(idArg);
    return projection;
  }

  public CartDiscountProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> cartDiscount(
      ) {
    CartDiscountProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new CartDiscountProjection<>(this, this);    
    getFields().put("cartDiscount", projection);
    return projection;
  }

  public CartDiscountProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> cartDiscount(
      String id, String key) {
    CartDiscountProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new CartDiscountProjection<>(this, this);    
    getFields().put("cartDiscount", projection);
    getInputArguments().computeIfAbsent("cartDiscount", k -> new ArrayList<>());                      
    InputArgument idArg = new InputArgument("id", id);
    getInputArguments().get("cartDiscount").add(idArg);
    InputArgument keyArg = new InputArgument("key", key);
    getInputArguments().get("cartDiscount").add(keyArg);
    return projection;
  }

  public CartDiscountQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> cartDiscounts(
      ) {
    CartDiscountQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new CartDiscountQueryResultProjection<>(this, this);    
    getFields().put("cartDiscounts", projection);
    return projection;
  }

  public CartDiscountQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> cartDiscounts(
      String where, List<String> sort, Integer limit, Integer offset) {
    CartDiscountQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new CartDiscountQueryResultProjection<>(this, this);    
    getFields().put("cartDiscounts", projection);
    getInputArguments().computeIfAbsent("cartDiscounts", k -> new ArrayList<>());                      
    InputArgument whereArg = new InputArgument("where", where);
    getInputArguments().get("cartDiscounts").add(whereArg);
    InputArgument sortArg = new InputArgument("sort", sort);
    getInputArguments().get("cartDiscounts").add(sortArg);
    InputArgument limitArg = new InputArgument("limit", limit);
    getInputArguments().get("cartDiscounts").add(limitArg);
    InputArgument offsetArg = new InputArgument("offset", offset);
    getInputArguments().get("cartDiscounts").add(offsetArg);
    return projection;
  }

  public ProductProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> product(
      ) {
    ProductProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new ProductProjection<>(this, this);    
    getFields().put("product", projection);
    return projection;
  }

  public ProductProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> product(
      Boolean projectExpandedProducts, List<String> localeProjection, String sku, String variantKey,
      String id, String key) {
    ProductProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new ProductProjection<>(this, this);    
    getFields().put("product", projection);
    getInputArguments().computeIfAbsent("product", k -> new ArrayList<>());                      
    InputArgument projectExpandedProductsArg = new InputArgument("projectExpandedProducts", projectExpandedProducts);
    getInputArguments().get("product").add(projectExpandedProductsArg);
    InputArgument localeProjectionArg = new InputArgument("localeProjection", localeProjection);
    getInputArguments().get("product").add(localeProjectionArg);
    InputArgument skuArg = new InputArgument("sku", sku);
    getInputArguments().get("product").add(skuArg);
    InputArgument variantKeyArg = new InputArgument("variantKey", variantKey);
    getInputArguments().get("product").add(variantKeyArg);
    InputArgument idArg = new InputArgument("id", id);
    getInputArguments().get("product").add(idArg);
    InputArgument keyArg = new InputArgument("key", key);
    getInputArguments().get("product").add(keyArg);
    return projection;
  }

  public CustomerProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> customer(
      ) {
    CustomerProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new CustomerProjection<>(this, this);    
    getFields().put("customer", projection);
    return projection;
  }

  public CustomerProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> customer(
      String emailToken, String passwordToken, String id, String key) {
    CustomerProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new CustomerProjection<>(this, this);    
    getFields().put("customer", projection);
    getInputArguments().computeIfAbsent("customer", k -> new ArrayList<>());                      
    InputArgument emailTokenArg = new InputArgument("emailToken", emailToken);
    getInputArguments().get("customer").add(emailTokenArg);
    InputArgument passwordTokenArg = new InputArgument("passwordToken", passwordToken);
    getInputArguments().get("customer").add(passwordTokenArg);
    InputArgument idArg = new InputArgument("id", id);
    getInputArguments().get("customer").add(idArg);
    InputArgument keyArg = new InputArgument("key", key);
    getInputArguments().get("customer").add(keyArg);
    return projection;
  }

  public CustomerQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> customers(
      ) {
    CustomerQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new CustomerQueryResultProjection<>(this, this);    
    getFields().put("customers", projection);
    return projection;
  }

  public CustomerQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> customers(
      String where, List<String> sort, Integer limit, Integer offset) {
    CustomerQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new CustomerQueryResultProjection<>(this, this);    
    getFields().put("customers", projection);
    getInputArguments().computeIfAbsent("customers", k -> new ArrayList<>());                      
    InputArgument whereArg = new InputArgument("where", where);
    getInputArguments().get("customers").add(whereArg);
    InputArgument sortArg = new InputArgument("sort", sort);
    getInputArguments().get("customers").add(sortArg);
    InputArgument limitArg = new InputArgument("limit", limit);
    getInputArguments().get("customers").add(limitArg);
    InputArgument offsetArg = new InputArgument("offset", offset);
    getInputArguments().get("customers").add(offsetArg);
    return projection;
  }

  public CartProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> cart(
      ) {
    CartProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new CartProjection<>(this, this);    
    getFields().put("cart", projection);
    return projection;
  }

  public CartProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> cart(
      String id) {
    CartProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new CartProjection<>(this, this);    
    getFields().put("cart", projection);
    getInputArguments().computeIfAbsent("cart", k -> new ArrayList<>());                      
    InputArgument idArg = new InputArgument("id", id);
    getInputArguments().get("cart").add(idArg);
    return projection;
  }

  public CartQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> carts(
      ) {
    CartQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new CartQueryResultProjection<>(this, this);    
    getFields().put("carts", projection);
    return projection;
  }

  public CartQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> carts(
      String where, List<String> sort, Integer limit, Integer offset) {
    CartQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new CartQueryResultProjection<>(this, this);    
    getFields().put("carts", projection);
    getInputArguments().computeIfAbsent("carts", k -> new ArrayList<>());                      
    InputArgument whereArg = new InputArgument("where", where);
    getInputArguments().get("carts").add(whereArg);
    InputArgument sortArg = new InputArgument("sort", sort);
    getInputArguments().get("carts").add(sortArg);
    InputArgument limitArg = new InputArgument("limit", limit);
    getInputArguments().get("carts").add(limitArg);
    InputArgument offsetArg = new InputArgument("offset", offset);
    getInputArguments().get("carts").add(offsetArg);
    return projection;
  }

  public CartProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> customerActiveCart(
      ) {
    CartProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new CartProjection<>(this, this);    
    getFields().put("customerActiveCart", projection);
    return projection;
  }

  public CartProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> customerActiveCart(
      String customerId) {
    CartProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new CartProjection<>(this, this);    
    getFields().put("customerActiveCart", projection);
    getInputArguments().computeIfAbsent("customerActiveCart", k -> new ArrayList<>());                      
    InputArgument customerIdArg = new InputArgument("customerId", customerId);
    getInputArguments().get("customerActiveCart").add(customerIdArg);
    return projection;
  }

  public OrderProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> order(
      ) {
    OrderProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new OrderProjection<>(this, this);    
    getFields().put("order", projection);
    return projection;
  }

  public OrderProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> order(
      String id, String orderNumber) {
    OrderProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new OrderProjection<>(this, this);    
    getFields().put("order", projection);
    getInputArguments().computeIfAbsent("order", k -> new ArrayList<>());                      
    InputArgument idArg = new InputArgument("id", id);
    getInputArguments().get("order").add(idArg);
    InputArgument orderNumberArg = new InputArgument("orderNumber", orderNumber);
    getInputArguments().get("order").add(orderNumberArg);
    return projection;
  }

  public OrderQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> orders(
      ) {
    OrderQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new OrderQueryResultProjection<>(this, this);    
    getFields().put("orders", projection);
    return projection;
  }

  public OrderQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> orders(
      String where, List<String> sort, Integer limit, Integer offset) {
    OrderQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new OrderQueryResultProjection<>(this, this);    
    getFields().put("orders", projection);
    getInputArguments().computeIfAbsent("orders", k -> new ArrayList<>());                      
    InputArgument whereArg = new InputArgument("where", where);
    getInputArguments().get("orders").add(whereArg);
    InputArgument sortArg = new InputArgument("sort", sort);
    getInputArguments().get("orders").add(sortArg);
    InputArgument limitArg = new InputArgument("limit", limit);
    getInputArguments().get("orders").add(limitArg);
    InputArgument offsetArg = new InputArgument("offset", offset);
    getInputArguments().get("orders").add(offsetArg);
    return projection;
  }

  public ShoppingListProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> shoppingList(
      ) {
    ShoppingListProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new ShoppingListProjection<>(this, this);    
    getFields().put("shoppingList", projection);
    return projection;
  }

  public ShoppingListProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> shoppingList(
      String id, String key) {
    ShoppingListProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new ShoppingListProjection<>(this, this);    
    getFields().put("shoppingList", projection);
    getInputArguments().computeIfAbsent("shoppingList", k -> new ArrayList<>());                      
    InputArgument idArg = new InputArgument("id", id);
    getInputArguments().get("shoppingList").add(idArg);
    InputArgument keyArg = new InputArgument("key", key);
    getInputArguments().get("shoppingList").add(keyArg);
    return projection;
  }

  public ShoppingListQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> shoppingLists(
      ) {
    ShoppingListQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new ShoppingListQueryResultProjection<>(this, this);    
    getFields().put("shoppingLists", projection);
    return projection;
  }

  public ShoppingListQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> shoppingLists(
      String where, List<String> sort, Integer limit, Integer offset) {
    ShoppingListQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new ShoppingListQueryResultProjection<>(this, this);    
    getFields().put("shoppingLists", projection);
    getInputArguments().computeIfAbsent("shoppingLists", k -> new ArrayList<>());                      
    InputArgument whereArg = new InputArgument("where", where);
    getInputArguments().get("shoppingLists").add(whereArg);
    InputArgument sortArg = new InputArgument("sort", sort);
    getInputArguments().get("shoppingLists").add(sortArg);
    InputArgument limitArg = new InputArgument("limit", limit);
    getInputArguments().get("shoppingLists").add(limitArg);
    InputArgument offsetArg = new InputArgument("offset", offset);
    getInputArguments().get("shoppingLists").add(offsetArg);
    return projection;
  }

  public ProductAssignmentQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> productSelectionAssignments(
      ) {
    ProductAssignmentQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new ProductAssignmentQueryResultProjection<>(this, this);    
    getFields().put("productSelectionAssignments", projection);
    return projection;
  }

  public ProductAssignmentQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> productSelectionAssignments(
      String where, List<String> sort, Integer limit, Integer offset) {
    ProductAssignmentQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new ProductAssignmentQueryResultProjection<>(this, this);    
    getFields().put("productSelectionAssignments", projection);
    getInputArguments().computeIfAbsent("productSelectionAssignments", k -> new ArrayList<>());                      
    InputArgument whereArg = new InputArgument("where", where);
    getInputArguments().get("productSelectionAssignments").add(whereArg);
    InputArgument sortArg = new InputArgument("sort", sort);
    getInputArguments().get("productSelectionAssignments").add(sortArg);
    InputArgument limitArg = new InputArgument("limit", limit);
    getInputArguments().get("productSelectionAssignments").add(limitArg);
    InputArgument offsetArg = new InputArgument("offset", offset);
    getInputArguments().get("productSelectionAssignments").add(offsetArg);
    return projection;
  }

  public ProductTailoringProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> productTailoring(
      ) {
    ProductTailoringProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new ProductTailoringProjection<>(this, this);    
    getFields().put("productTailoring", projection);
    return projection;
  }

  public ProductTailoringProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> productTailoring(
      String id, String key, String productId, String productKey) {
    ProductTailoringProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new ProductTailoringProjection<>(this, this);    
    getFields().put("productTailoring", projection);
    getInputArguments().computeIfAbsent("productTailoring", k -> new ArrayList<>());                      
    InputArgument idArg = new InputArgument("id", id);
    getInputArguments().get("productTailoring").add(idArg);
    InputArgument keyArg = new InputArgument("key", key);
    getInputArguments().get("productTailoring").add(keyArg);
    InputArgument productIdArg = new InputArgument("productId", productId);
    getInputArguments().get("productTailoring").add(productIdArg);
    InputArgument productKeyArg = new InputArgument("productKey", productKey);
    getInputArguments().get("productTailoring").add(productKeyArg);
    return projection;
  }

  public ProductTailoringQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> productTailoringList(
      ) {
    ProductTailoringQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new ProductTailoringQueryResultProjection<>(this, this);    
    getFields().put("productTailoringList", projection);
    return projection;
  }

  public ProductTailoringQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> productTailoringList(
      String where, List<String> sort, Integer limit, Integer offset) {
    ProductTailoringQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new ProductTailoringQueryResultProjection<>(this, this);    
    getFields().put("productTailoringList", projection);
    getInputArguments().computeIfAbsent("productTailoringList", k -> new ArrayList<>());                      
    InputArgument whereArg = new InputArgument("where", where);
    getInputArguments().get("productTailoringList").add(whereArg);
    InputArgument sortArg = new InputArgument("sort", sort);
    getInputArguments().get("productTailoringList").add(sortArg);
    InputArgument limitArg = new InputArgument("limit", limit);
    getInputArguments().get("productTailoringList").add(limitArg);
    InputArgument offsetArg = new InputArgument("offset", offset);
    getInputArguments().get("productTailoringList").add(offsetArg);
    return projection;
  }

  public QuoteRequestProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> quoteRequest(
      ) {
    QuoteRequestProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new QuoteRequestProjection<>(this, this);    
    getFields().put("quoteRequest", projection);
    return projection;
  }

  public QuoteRequestProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> quoteRequest(
      String id, String key) {
    QuoteRequestProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new QuoteRequestProjection<>(this, this);    
    getFields().put("quoteRequest", projection);
    getInputArguments().computeIfAbsent("quoteRequest", k -> new ArrayList<>());                      
    InputArgument idArg = new InputArgument("id", id);
    getInputArguments().get("quoteRequest").add(idArg);
    InputArgument keyArg = new InputArgument("key", key);
    getInputArguments().get("quoteRequest").add(keyArg);
    return projection;
  }

  public QuoteRequestQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> quoteRequests(
      ) {
    QuoteRequestQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new QuoteRequestQueryResultProjection<>(this, this);    
    getFields().put("quoteRequests", projection);
    return projection;
  }

  public QuoteRequestQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> quoteRequests(
      String where, List<String> sort, Integer limit, Integer offset) {
    QuoteRequestQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new QuoteRequestQueryResultProjection<>(this, this);    
    getFields().put("quoteRequests", projection);
    getInputArguments().computeIfAbsent("quoteRequests", k -> new ArrayList<>());                      
    InputArgument whereArg = new InputArgument("where", where);
    getInputArguments().get("quoteRequests").add(whereArg);
    InputArgument sortArg = new InputArgument("sort", sort);
    getInputArguments().get("quoteRequests").add(sortArg);
    InputArgument limitArg = new InputArgument("limit", limit);
    getInputArguments().get("quoteRequests").add(limitArg);
    InputArgument offsetArg = new InputArgument("offset", offset);
    getInputArguments().get("quoteRequests").add(offsetArg);
    return projection;
  }

  public StagedQuoteProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> stagedQuote(
      ) {
    StagedQuoteProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new StagedQuoteProjection<>(this, this);    
    getFields().put("stagedQuote", projection);
    return projection;
  }

  public StagedQuoteProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> stagedQuote(
      String id, String key) {
    StagedQuoteProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new StagedQuoteProjection<>(this, this);    
    getFields().put("stagedQuote", projection);
    getInputArguments().computeIfAbsent("stagedQuote", k -> new ArrayList<>());                      
    InputArgument idArg = new InputArgument("id", id);
    getInputArguments().get("stagedQuote").add(idArg);
    InputArgument keyArg = new InputArgument("key", key);
    getInputArguments().get("stagedQuote").add(keyArg);
    return projection;
  }

  public StagedQuoteQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> stagedQuotes(
      ) {
    StagedQuoteQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new StagedQuoteQueryResultProjection<>(this, this);    
    getFields().put("stagedQuotes", projection);
    return projection;
  }

  public StagedQuoteQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> stagedQuotes(
      String where, List<String> sort, Integer limit, Integer offset) {
    StagedQuoteQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new StagedQuoteQueryResultProjection<>(this, this);    
    getFields().put("stagedQuotes", projection);
    getInputArguments().computeIfAbsent("stagedQuotes", k -> new ArrayList<>());                      
    InputArgument whereArg = new InputArgument("where", where);
    getInputArguments().get("stagedQuotes").add(whereArg);
    InputArgument sortArg = new InputArgument("sort", sort);
    getInputArguments().get("stagedQuotes").add(sortArg);
    InputArgument limitArg = new InputArgument("limit", limit);
    getInputArguments().get("stagedQuotes").add(limitArg);
    InputArgument offsetArg = new InputArgument("offset", offset);
    getInputArguments().get("stagedQuotes").add(offsetArg);
    return projection;
  }

  public QuoteProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> quote(
      ) {
    QuoteProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new QuoteProjection<>(this, this);    
    getFields().put("quote", projection);
    return projection;
  }

  public QuoteProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> quote(
      String id, String key) {
    QuoteProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new QuoteProjection<>(this, this);    
    getFields().put("quote", projection);
    getInputArguments().computeIfAbsent("quote", k -> new ArrayList<>());                      
    InputArgument idArg = new InputArgument("id", id);
    getInputArguments().get("quote").add(idArg);
    InputArgument keyArg = new InputArgument("key", key);
    getInputArguments().get("quote").add(keyArg);
    return projection;
  }

  public QuoteQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> quotes(
      ) {
    QuoteQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new QuoteQueryResultProjection<>(this, this);    
    getFields().put("quotes", projection);
    return projection;
  }

  public QuoteQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> quotes(
      String where, List<String> sort, Integer limit, Integer offset) {
    QuoteQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new QuoteQueryResultProjection<>(this, this);    
    getFields().put("quotes", projection);
    getInputArguments().computeIfAbsent("quotes", k -> new ArrayList<>());                      
    InputArgument whereArg = new InputArgument("where", where);
    getInputArguments().get("quotes").add(whereArg);
    InputArgument sortArg = new InputArgument("sort", sort);
    getInputArguments().get("quotes").add(sortArg);
    InputArgument limitArg = new InputArgument("limit", limit);
    getInputArguments().get("quotes").add(limitArg);
    InputArgument offsetArg = new InputArgument("offset", offset);
    getInputArguments().get("quotes").add(offsetArg);
    return projection;
  }

  public BusinessUnitProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> businessUnit(
      ) {
    BusinessUnitProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new BusinessUnitProjection<>(this, this);    
    getFields().put("businessUnit", projection);
    return projection;
  }

  public BusinessUnitProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> businessUnit(
      String id, String key) {
    BusinessUnitProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new BusinessUnitProjection<>(this, this);    
    getFields().put("businessUnit", projection);
    getInputArguments().computeIfAbsent("businessUnit", k -> new ArrayList<>());                      
    InputArgument idArg = new InputArgument("id", id);
    getInputArguments().get("businessUnit").add(idArg);
    InputArgument keyArg = new InputArgument("key", key);
    getInputArguments().get("businessUnit").add(keyArg);
    return projection;
  }

  public BusinessUnitQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> businessUnits(
      ) {
    BusinessUnitQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new BusinessUnitQueryResultProjection<>(this, this);    
    getFields().put("businessUnits", projection);
    return projection;
  }

  public BusinessUnitQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> businessUnits(
      String where, List<String> sort, Integer limit, Integer offset) {
    BusinessUnitQueryResultProjection<InStoreProjectionRoot<PARENT, ROOT>, InStoreProjectionRoot<PARENT, ROOT>> projection = new BusinessUnitQueryResultProjection<>(this, this);    
    getFields().put("businessUnits", projection);
    getInputArguments().computeIfAbsent("businessUnits", k -> new ArrayList<>());                      
    InputArgument whereArg = new InputArgument("where", where);
    getInputArguments().get("businessUnits").add(whereArg);
    InputArgument sortArg = new InputArgument("sort", sort);
    getInputArguments().get("businessUnits").add(sortArg);
    InputArgument limitArg = new InputArgument("limit", limit);
    getInputArguments().get("businessUnits").add(limitArg);
    InputArgument offsetArg = new InputArgument("offset", offset);
    getInputArguments().get("businessUnits").add(offsetArg);
    return projection;
  }
}
