package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class InventoryEntriesGraphQLQuery extends GraphQLQuery {
  public InventoryEntriesGraphQLQuery(String where, List<String> sort, Integer limit,
      Integer offset, String queryName, Set<String> fieldsSet) {
    super("query", queryName);
    if (where != null || fieldsSet.contains("where")) {
        getInput().put("where", where);
    }if (sort != null || fieldsSet.contains("sort")) {
        getInput().put("sort", sort);
    }if (limit != null || fieldsSet.contains("limit")) {
        getInput().put("limit", limit);
    }if (offset != null || fieldsSet.contains("offset")) {
        getInput().put("offset", offset);
    }
  }

  public InventoryEntriesGraphQLQuery() {
    super("query");
  }

  @Override
  public String getOperationName() {
    return "inventoryEntries";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private String where;

    private List<String> sort;

    private Integer limit;

    private Integer offset;

    private String queryName;

    public InventoryEntriesGraphQLQuery build() {
      return new InventoryEntriesGraphQLQuery(where, sort, limit, offset, queryName, fieldsSet);
               
    }

    public Builder where(String where) {
      this.where = where;
      this.fieldsSet.add("where");
      return this;
    }

    public Builder sort(List<String> sort) {
      this.sort = sort;
      this.fieldsSet.add("sort");
      return this;
    }

    public Builder limit(Integer limit) {
      this.limit = limit;
      this.fieldsSet.add("limit");
      return this;
    }

    public Builder offset(Integer offset) {
      this.offset = offset;
      this.fieldsSet.add("offset");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
