package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.BaseSubProjectionNode;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public class OrderFragmentProjection<PARENT extends BaseSubProjectionNode<?, ?>, ROOT extends BaseSubProjectionNode<?, ?>> extends BaseSubProjectionNode<PARENT, ROOT> {
  {
    getFields().put("__typename", null);
  }

  public OrderFragmentProjection(PARENT parent, ROOT root) {
    super(parent, root, java.util.Optional.of("Order"));
  }

  public OrderFragmentProjection<PARENT, ROOT> __typename() {
    getFields().put("__typename", null);
    return this;
  }

  public CustomerProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> customer() {
     CustomerProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new CustomerProjection<>(this, getRoot());
     getFields().put("customer", projection);
     return projection;
  }

  public LineItemProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> lineItems() {
     LineItemProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new LineItemProjection<>(this, getRoot());
     getFields().put("lineItems", projection);
     return projection;
  }

  public LineItemProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> lineItems(String id) {
    LineItemProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new LineItemProjection<>(this, getRoot());    
    getFields().put("lineItems", projection);
    getInputArguments().computeIfAbsent("lineItems", k -> new ArrayList<>());                      
    InputArgument idArg = new InputArgument("id", id);
    getInputArguments().get("lineItems").add(idArg);
    return projection;
  }

  public CustomLineItemProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> customLineItems() {
     CustomLineItemProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new CustomLineItemProjection<>(this, getRoot());
     getFields().put("customLineItems", projection);
     return projection;
  }

  public MoneyProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> totalPrice() {
     MoneyProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new MoneyProjection<>(this, getRoot());
     getFields().put("totalPrice", projection);
     return projection;
  }

  public TaxedPriceProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> taxedPrice() {
     TaxedPriceProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new TaxedPriceProjection<>(this, getRoot());
     getFields().put("taxedPrice", projection);
     return projection;
  }

  public DiscountOnTotalPriceProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> discountOnTotalPrice(
      ) {
     DiscountOnTotalPriceProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new DiscountOnTotalPriceProjection<>(this, getRoot());
     getFields().put("discountOnTotalPrice", projection);
     return projection;
  }

  public AddressProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> shippingAddress() {
     AddressProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new AddressProjection<>(this, getRoot());
     getFields().put("shippingAddress", projection);
     return projection;
  }

  public AddressProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> billingAddress() {
     AddressProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new AddressProjection<>(this, getRoot());
     getFields().put("billingAddress", projection);
     return projection;
  }

  public InventoryModeProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> inventoryMode() {
     InventoryModeProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new InventoryModeProjection<>(this, getRoot());
     getFields().put("inventoryMode", projection);
     return projection;
  }

  public TaxModeProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> taxMode() {
     TaxModeProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new TaxModeProjection<>(this, getRoot());
     getFields().put("taxMode", projection);
     return projection;
  }

  public RoundingModeProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> taxRoundingMode() {
     RoundingModeProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new RoundingModeProjection<>(this, getRoot());
     getFields().put("taxRoundingMode", projection);
     return projection;
  }

  public TaxCalculationModeProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> taxCalculationMode(
      ) {
     TaxCalculationModeProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new TaxCalculationModeProjection<>(this, getRoot());
     getFields().put("taxCalculationMode", projection);
     return projection;
  }

  public CustomerGroupProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> customerGroup() {
     CustomerGroupProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new CustomerGroupProjection<>(this, getRoot());
     getFields().put("customerGroup", projection);
     return projection;
  }

  public ReferenceProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> customerGroupRef() {
     ReferenceProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("customerGroupRef", projection);
     return projection;
  }

  public ShippingInfoProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> shippingInfo() {
     ShippingInfoProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new ShippingInfoProjection<>(this, getRoot());
     getFields().put("shippingInfo", projection);
     return projection;
  }

  public DiscountCodeInfoProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> discountCodes() {
     DiscountCodeInfoProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new DiscountCodeInfoProjection<>(this, getRoot());
     getFields().put("discountCodes", projection);
     return projection;
  }

  public DirectDiscountProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> directDiscounts() {
     DirectDiscountProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new DirectDiscountProjection<>(this, getRoot());
     getFields().put("directDiscounts", projection);
     return projection;
  }

  public DiscountTypeCombinationProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> discountTypeCombination(
      ) {
     DiscountTypeCombinationProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new DiscountTypeCombinationProjection<>(this, getRoot());
     getFields().put("discountTypeCombination", projection);
     return projection;
  }

  public CartDiscountProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> refusedGifts() {
     CartDiscountProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new CartDiscountProjection<>(this, getRoot());
     getFields().put("refusedGifts", projection);
     return projection;
  }

  public ReferenceProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> refusedGiftsRefs() {
     ReferenceProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("refusedGiftsRefs", projection);
     return projection;
  }

  public PaymentInfoProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> paymentInfo() {
     PaymentInfoProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new PaymentInfoProjection<>(this, getRoot());
     getFields().put("paymentInfo", projection);
     return projection;
  }

  public ShippingRateInputProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> shippingRateInput(
      ) {
     ShippingRateInputProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new ShippingRateInputProjection<>(this, getRoot());
     getFields().put("shippingRateInput", projection);
     return projection;
  }

  public CartOriginProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> origin() {
     CartOriginProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new CartOriginProjection<>(this, getRoot());
     getFields().put("origin", projection);
     return projection;
  }

  public KeyReferenceProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> storeRef() {
     KeyReferenceProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new KeyReferenceProjection<>(this, getRoot());
     getFields().put("storeRef", projection);
     return projection;
  }

  public StoreProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> store() {
     StoreProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new StoreProjection<>(this, getRoot());
     getFields().put("store", projection);
     return projection;
  }

  public AddressProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> itemShippingAddresses() {
     AddressProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new AddressProjection<>(this, getRoot());
     getFields().put("itemShippingAddresses", projection);
     return projection;
  }

  public BusinessUnitProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> businessUnit() {
     BusinessUnitProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new BusinessUnitProjection<>(this, getRoot());
     getFields().put("businessUnit", projection);
     return projection;
  }

  public KeyReferenceProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> businessUnitRef() {
     KeyReferenceProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new KeyReferenceProjection<>(this, getRoot());
     getFields().put("businessUnitRef", projection);
     return projection;
  }

  public ShippingProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> shipping() {
     ShippingProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new ShippingProjection<>(this, getRoot());
     getFields().put("shipping", projection);
     return projection;
  }

  public TaxedPriceProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> taxedShippingPrice() {
     TaxedPriceProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new TaxedPriceProjection<>(this, getRoot());
     getFields().put("taxedShippingPrice", projection);
     return projection;
  }

  public ShippingModeProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> shippingMode() {
     ShippingModeProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new ShippingModeProjection<>(this, getRoot());
     getFields().put("shippingMode", projection);
     return projection;
  }

  public CustomFieldsTypeProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> shippingCustomFields(
      ) {
     CustomFieldsTypeProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new CustomFieldsTypeProjection<>(this, getRoot());
     getFields().put("shippingCustomFields", projection);
     return projection;
  }

  public OrderStateProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> orderState() {
     OrderStateProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new OrderStateProjection<>(this, getRoot());
     getFields().put("orderState", projection);
     return projection;
  }

  public ReferenceProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> stateRef() {
     ReferenceProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("stateRef", projection);
     return projection;
  }

  public StateProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> state() {
     StateProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new StateProjection<>(this, getRoot());
     getFields().put("state", projection);
     return projection;
  }

  public ShipmentStateProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> shipmentState() {
     ShipmentStateProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new ShipmentStateProjection<>(this, getRoot());
     getFields().put("shipmentState", projection);
     return projection;
  }

  public PaymentStateProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> paymentState() {
     PaymentStateProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new PaymentStateProjection<>(this, getRoot());
     getFields().put("paymentState", projection);
     return projection;
  }

  public SyncInfoProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> syncInfo() {
     SyncInfoProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new SyncInfoProjection<>(this, getRoot());
     getFields().put("syncInfo", projection);
     return projection;
  }

  public ReturnInfoProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> returnInfo() {
     ReturnInfoProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new ReturnInfoProjection<>(this, getRoot());
     getFields().put("returnInfo", projection);
     return projection;
  }

  public ReferenceProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> cartRef() {
     ReferenceProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("cartRef", projection);
     return projection;
  }

  public CartProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> cart() {
     CartProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new CartProjection<>(this, getRoot());
     getFields().put("cart", projection);
     return projection;
  }

  public ReferenceProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> quoteRef() {
     ReferenceProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("quoteRef", projection);
     return projection;
  }

  public QuoteProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> quote() {
     QuoteProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new QuoteProjection<>(this, getRoot());
     getFields().put("quote", projection);
     return projection;
  }

  public CustomFieldsTypeProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> custom() {
     CustomFieldsTypeProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new CustomFieldsTypeProjection<>(this, getRoot());
     getFields().put("custom", projection);
     return projection;
  }

  public InitiatorProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> createdBy() {
     InitiatorProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new InitiatorProjection<>(this, getRoot());
     getFields().put("createdBy", projection);
     return projection;
  }

  public InitiatorProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> lastModifiedBy() {
     InitiatorProjection<OrderFragmentProjection<PARENT, ROOT>, ROOT> projection = new InitiatorProjection<>(this, getRoot());
     getFields().put("lastModifiedBy", projection);
     return projection;
  }

  public OrderFragmentProjection<PARENT, ROOT> customerId() {
    getFields().put("customerId", null);
    return this;
  }

  public OrderFragmentProjection<PARENT, ROOT> customerEmail() {
    getFields().put("customerEmail", null);
    return this;
  }

  public OrderFragmentProjection<PARENT, ROOT> anonymousId() {
    getFields().put("anonymousId", null);
    return this;
  }

  public OrderFragmentProjection<PARENT, ROOT> country() {
    getFields().put("country", null);
    return this;
  }

  public OrderFragmentProjection<PARENT, ROOT> shippingKey() {
    getFields().put("shippingKey", null);
    return this;
  }

  public OrderFragmentProjection<PARENT, ROOT> locale() {
    getFields().put("locale", null);
    return this;
  }

  public OrderFragmentProjection<PARENT, ROOT> completedAt() {
    getFields().put("completedAt", null);
    return this;
  }

  public OrderFragmentProjection<PARENT, ROOT> orderNumber() {
    getFields().put("orderNumber", null);
    return this;
  }

  public OrderFragmentProjection<PARENT, ROOT> purchaseOrderNumber() {
    getFields().put("purchaseOrderNumber", null);
    return this;
  }

  public OrderFragmentProjection<PARENT, ROOT> lastMessageSequenceNumber() {
    getFields().put("lastMessageSequenceNumber", null);
    return this;
  }

  public OrderFragmentProjection<PARENT, ROOT> id() {
    getFields().put("id", null);
    return this;
  }

  public OrderFragmentProjection<PARENT, ROOT> version() {
    getFields().put("version", null);
    return this;
  }

  public OrderFragmentProjection<PARENT, ROOT> createdAt() {
    getFields().put("createdAt", null);
    return this;
  }

  public OrderFragmentProjection<PARENT, ROOT> lastModifiedAt() {
    getFields().put("lastModifiedAt", null);
    return this;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    builder.append("... on Order {");
    getFields().forEach((k, v) -> {
        builder.append(" ").append(k);
        if(v != null) {
            builder.append(" ").append(v.toString());
        }
    });
    builder.append("}");
     
    return builder.toString();
  }
}
