package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.BaseSubProjectionNode;
import java.lang.Integer;
import java.util.ArrayList;

public class PaymentProjection<PARENT extends BaseSubProjectionNode<?, ?>, ROOT extends BaseSubProjectionNode<?, ?>> extends BaseSubProjectionNode<PARENT, ROOT> {
  public PaymentProjection(PARENT parent, ROOT root) {
    super(parent, root, java.util.Optional.of("Payment"));
  }

  public PaymentProjection<PARENT, ROOT> __typename() {
    getFields().put("__typename", null);
    return this;
  }

  public ReferenceProjection<PaymentProjection<PARENT, ROOT>, ROOT> customerRef() {
     ReferenceProjection<PaymentProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("customerRef", projection);
     return projection;
  }

  public CustomerProjection<PaymentProjection<PARENT, ROOT>, ROOT> customer() {
     CustomerProjection<PaymentProjection<PARENT, ROOT>, ROOT> projection = new CustomerProjection<>(this, getRoot());
     getFields().put("customer", projection);
     return projection;
  }

  public MoneyProjection<PaymentProjection<PARENT, ROOT>, ROOT> amountPlanned() {
     MoneyProjection<PaymentProjection<PARENT, ROOT>, ROOT> projection = new MoneyProjection<>(this, getRoot());
     getFields().put("amountPlanned", projection);
     return projection;
  }

  public PaymentMethodInfoProjection<PaymentProjection<PARENT, ROOT>, ROOT> paymentMethodInfo() {
     PaymentMethodInfoProjection<PaymentProjection<PARENT, ROOT>, ROOT> projection = new PaymentMethodInfoProjection<>(this, getRoot());
     getFields().put("paymentMethodInfo", projection);
     return projection;
  }

  public PaymentStatusProjection<PaymentProjection<PARENT, ROOT>, ROOT> paymentStatus() {
     PaymentStatusProjection<PaymentProjection<PARENT, ROOT>, ROOT> projection = new PaymentStatusProjection<>(this, getRoot());
     getFields().put("paymentStatus", projection);
     return projection;
  }

  public TransactionProjection<PaymentProjection<PARENT, ROOT>, ROOT> transactions() {
     TransactionProjection<PaymentProjection<PARENT, ROOT>, ROOT> projection = new TransactionProjection<>(this, getRoot());
     getFields().put("transactions", projection);
     return projection;
  }

  public InterfaceInteractionsRawResultProjection<PaymentProjection<PARENT, ROOT>, ROOT> interfaceInteractionsRaw(
      ) {
     InterfaceInteractionsRawResultProjection<PaymentProjection<PARENT, ROOT>, ROOT> projection = new InterfaceInteractionsRawResultProjection<>(this, getRoot());
     getFields().put("interfaceInteractionsRaw", projection);
     return projection;
  }

  public InterfaceInteractionsRawResultProjection<PaymentProjection<PARENT, ROOT>, ROOT> interfaceInteractionsRaw(
      Integer limit, Integer offset) {
    InterfaceInteractionsRawResultProjection<PaymentProjection<PARENT, ROOT>, ROOT> projection = new InterfaceInteractionsRawResultProjection<>(this, getRoot());    
    getFields().put("interfaceInteractionsRaw", projection);
    getInputArguments().computeIfAbsent("interfaceInteractionsRaw", k -> new ArrayList<>());                      
    InputArgument limitArg = new InputArgument("limit", limit);
    getInputArguments().get("interfaceInteractionsRaw").add(limitArg);
    InputArgument offsetArg = new InputArgument("offset", offset);
    getInputArguments().get("interfaceInteractionsRaw").add(offsetArg);
    return projection;
  }

  public CustomFieldsTypeProjection<PaymentProjection<PARENT, ROOT>, ROOT> custom() {
     CustomFieldsTypeProjection<PaymentProjection<PARENT, ROOT>, ROOT> projection = new CustomFieldsTypeProjection<>(this, getRoot());
     getFields().put("custom", projection);
     return projection;
  }

  public InitiatorProjection<PaymentProjection<PARENT, ROOT>, ROOT> createdBy() {
     InitiatorProjection<PaymentProjection<PARENT, ROOT>, ROOT> projection = new InitiatorProjection<>(this, getRoot());
     getFields().put("createdBy", projection);
     return projection;
  }

  public InitiatorProjection<PaymentProjection<PARENT, ROOT>, ROOT> lastModifiedBy() {
     InitiatorProjection<PaymentProjection<PARENT, ROOT>, ROOT> projection = new InitiatorProjection<>(this, getRoot());
     getFields().put("lastModifiedBy", projection);
     return projection;
  }

  public PaymentProjection<PARENT, ROOT> key() {
    getFields().put("key", null);
    return this;
  }

  public PaymentProjection<PARENT, ROOT> anonymousId() {
    getFields().put("anonymousId", null);
    return this;
  }

  public PaymentProjection<PARENT, ROOT> interfaceId() {
    getFields().put("interfaceId", null);
    return this;
  }

  public PaymentProjection<PARENT, ROOT> id() {
    getFields().put("id", null);
    return this;
  }

  public PaymentProjection<PARENT, ROOT> version() {
    getFields().put("version", null);
    return this;
  }

  public PaymentProjection<PARENT, ROOT> createdAt() {
    getFields().put("createdAt", null);
    return this;
  }

  public PaymentProjection<PARENT, ROOT> lastModifiedAt() {
    getFields().put("lastModifiedAt", null);
    return this;
  }
}
