package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.BaseSubProjectionNode;
import java.lang.Boolean;
import java.lang.String;
import java.util.ArrayList;
import java.util.List;

public class ProductDataProjection<PARENT extends BaseSubProjectionNode<?, ?>, ROOT extends BaseSubProjectionNode<?, ?>> extends BaseSubProjectionNode<PARENT, ROOT> {
  public ProductDataProjection(PARENT parent, ROOT root) {
    super(parent, root, java.util.Optional.of("ProductData"));
  }

  public ProductDataProjection<PARENT, ROOT> __typename() {
    getFields().put("__typename", null);
    return this;
  }

  public LocalizedStringProjection<ProductDataProjection<PARENT, ROOT>, ROOT> nameAllLocales() {
     LocalizedStringProjection<ProductDataProjection<PARENT, ROOT>, ROOT> projection = new LocalizedStringProjection<>(this, getRoot());
     getFields().put("nameAllLocales", projection);
     return projection;
  }

  public LocalizedStringProjection<ProductDataProjection<PARENT, ROOT>, ROOT> descriptionAllLocales(
      ) {
     LocalizedStringProjection<ProductDataProjection<PARENT, ROOT>, ROOT> projection = new LocalizedStringProjection<>(this, getRoot());
     getFields().put("descriptionAllLocales", projection);
     return projection;
  }

  public LocalizedStringProjection<ProductDataProjection<PARENT, ROOT>, ROOT> slugAllLocales() {
     LocalizedStringProjection<ProductDataProjection<PARENT, ROOT>, ROOT> projection = new LocalizedStringProjection<>(this, getRoot());
     getFields().put("slugAllLocales", projection);
     return projection;
  }

  public CategoryOrderHintProjection<ProductDataProjection<PARENT, ROOT>, ROOT> categoryOrderHints(
      ) {
     CategoryOrderHintProjection<ProductDataProjection<PARENT, ROOT>, ROOT> projection = new CategoryOrderHintProjection<>(this, getRoot());
     getFields().put("categoryOrderHints", projection);
     return projection;
  }

  public ReferenceProjection<ProductDataProjection<PARENT, ROOT>, ROOT> categoriesRef() {
     ReferenceProjection<ProductDataProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("categoriesRef", projection);
     return projection;
  }

  public CategoryProjection<ProductDataProjection<PARENT, ROOT>, ROOT> categories() {
     CategoryProjection<ProductDataProjection<PARENT, ROOT>, ROOT> projection = new CategoryProjection<>(this, getRoot());
     getFields().put("categories", projection);
     return projection;
  }

  public SearchKeywordProjection<ProductDataProjection<PARENT, ROOT>, ROOT> searchKeyword() {
     SearchKeywordProjection<ProductDataProjection<PARENT, ROOT>, ROOT> projection = new SearchKeywordProjection<>(this, getRoot());
     getFields().put("searchKeyword", projection);
     return projection;
  }

  public SearchKeywordProjection<ProductDataProjection<PARENT, ROOT>, ROOT> searchKeyword(
      String locale) {
    SearchKeywordProjection<ProductDataProjection<PARENT, ROOT>, ROOT> projection = new SearchKeywordProjection<>(this, getRoot());    
    getFields().put("searchKeyword", projection);
    getInputArguments().computeIfAbsent("searchKeyword", k -> new ArrayList<>());                      
    InputArgument localeArg = new InputArgument("locale", locale);
    getInputArguments().get("searchKeyword").add(localeArg);
    return projection;
  }

  public SearchKeywordsProjection<ProductDataProjection<PARENT, ROOT>, ROOT> searchKeywords() {
     SearchKeywordsProjection<ProductDataProjection<PARENT, ROOT>, ROOT> projection = new SearchKeywordsProjection<>(this, getRoot());
     getFields().put("searchKeywords", projection);
     return projection;
  }

  public LocalizedStringProjection<ProductDataProjection<PARENT, ROOT>, ROOT> metaTitleAllLocales(
      ) {
     LocalizedStringProjection<ProductDataProjection<PARENT, ROOT>, ROOT> projection = new LocalizedStringProjection<>(this, getRoot());
     getFields().put("metaTitleAllLocales", projection);
     return projection;
  }

  public LocalizedStringProjection<ProductDataProjection<PARENT, ROOT>, ROOT> metaKeywordsAllLocales(
      ) {
     LocalizedStringProjection<ProductDataProjection<PARENT, ROOT>, ROOT> projection = new LocalizedStringProjection<>(this, getRoot());
     getFields().put("metaKeywordsAllLocales", projection);
     return projection;
  }

  public LocalizedStringProjection<ProductDataProjection<PARENT, ROOT>, ROOT> metaDescriptionAllLocales(
      ) {
     LocalizedStringProjection<ProductDataProjection<PARENT, ROOT>, ROOT> projection = new LocalizedStringProjection<>(this, getRoot());
     getFields().put("metaDescriptionAllLocales", projection);
     return projection;
  }

  public ProductVariantProjection<ProductDataProjection<PARENT, ROOT>, ROOT> masterVariant() {
     ProductVariantProjection<ProductDataProjection<PARENT, ROOT>, ROOT> projection = new ProductVariantProjection<>(this, getRoot());
     getFields().put("masterVariant", projection);
     return projection;
  }

  public ProductVariantProjection<ProductDataProjection<PARENT, ROOT>, ROOT> variants() {
     ProductVariantProjection<ProductDataProjection<PARENT, ROOT>, ROOT> projection = new ProductVariantProjection<>(this, getRoot());
     getFields().put("variants", projection);
     return projection;
  }

  public ProductVariantProjection<ProductDataProjection<PARENT, ROOT>, ROOT> variants(
      List<String> skus, Boolean isOnStock, List<String> stockChannelIds, Boolean hasImages) {
    ProductVariantProjection<ProductDataProjection<PARENT, ROOT>, ROOT> projection = new ProductVariantProjection<>(this, getRoot());    
    getFields().put("variants", projection);
    getInputArguments().computeIfAbsent("variants", k -> new ArrayList<>());                      
    InputArgument skusArg = new InputArgument("skus", skus);
    getInputArguments().get("variants").add(skusArg);
    InputArgument isOnStockArg = new InputArgument("isOnStock", isOnStock);
    getInputArguments().get("variants").add(isOnStockArg);
    InputArgument stockChannelIdsArg = new InputArgument("stockChannelIds", stockChannelIds);
    getInputArguments().get("variants").add(stockChannelIdsArg);
    InputArgument hasImagesArg = new InputArgument("hasImages", hasImages);
    getInputArguments().get("variants").add(hasImagesArg);
    return projection;
  }

  public ProductVariantProjection<ProductDataProjection<PARENT, ROOT>, ROOT> allVariants() {
     ProductVariantProjection<ProductDataProjection<PARENT, ROOT>, ROOT> projection = new ProductVariantProjection<>(this, getRoot());
     getFields().put("allVariants", projection);
     return projection;
  }

  public ProductVariantProjection<ProductDataProjection<PARENT, ROOT>, ROOT> allVariants(
      List<String> skus, Boolean isOnStock, List<String> stockChannelIds, Boolean hasImages) {
    ProductVariantProjection<ProductDataProjection<PARENT, ROOT>, ROOT> projection = new ProductVariantProjection<>(this, getRoot());    
    getFields().put("allVariants", projection);
    getInputArguments().computeIfAbsent("allVariants", k -> new ArrayList<>());                      
    InputArgument skusArg = new InputArgument("skus", skus);
    getInputArguments().get("allVariants").add(skusArg);
    InputArgument isOnStockArg = new InputArgument("isOnStock", isOnStock);
    getInputArguments().get("allVariants").add(isOnStockArg);
    InputArgument stockChannelIdsArg = new InputArgument("stockChannelIds", stockChannelIds);
    getInputArguments().get("allVariants").add(stockChannelIdsArg);
    InputArgument hasImagesArg = new InputArgument("hasImages", hasImages);
    getInputArguments().get("allVariants").add(hasImagesArg);
    return projection;
  }

  public ProductVariantProjection<ProductDataProjection<PARENT, ROOT>, ROOT> variant() {
     ProductVariantProjection<ProductDataProjection<PARENT, ROOT>, ROOT> projection = new ProductVariantProjection<>(this, getRoot());
     getFields().put("variant", projection);
     return projection;
  }

  public ProductVariantProjection<ProductDataProjection<PARENT, ROOT>, ROOT> variant(String sku,
      String key) {
    ProductVariantProjection<ProductDataProjection<PARENT, ROOT>, ROOT> projection = new ProductVariantProjection<>(this, getRoot());    
    getFields().put("variant", projection);
    getInputArguments().computeIfAbsent("variant", k -> new ArrayList<>());                      
    InputArgument skuArg = new InputArgument("sku", sku);
    getInputArguments().get("variant").add(skuArg);
    InputArgument keyArg = new InputArgument("key", key);
    getInputArguments().get("variant").add(keyArg);
    return projection;
  }

  public ProductDataProjection<PARENT, ROOT> name() {
    getFields().put("name", null);
    return this;
  }

  public ProductDataProjection name(String locale, List<String> acceptLanguage) {
    getFields().put("name", null);
    getInputArguments().computeIfAbsent("name", k -> new ArrayList<>());
    InputArgument localeArg = new InputArgument("locale", locale);
    getInputArguments().get("name").add(localeArg);
    InputArgument acceptLanguageArg = new InputArgument("acceptLanguage", acceptLanguage);
    getInputArguments().get("name").add(acceptLanguageArg);
    return this;
  }

  public ProductDataProjection<PARENT, ROOT> description() {
    getFields().put("description", null);
    return this;
  }

  public ProductDataProjection description(String locale, List<String> acceptLanguage) {
    getFields().put("description", null);
    getInputArguments().computeIfAbsent("description", k -> new ArrayList<>());
    InputArgument localeArg = new InputArgument("locale", locale);
    getInputArguments().get("description").add(localeArg);
    InputArgument acceptLanguageArg = new InputArgument("acceptLanguage", acceptLanguage);
    getInputArguments().get("description").add(acceptLanguageArg);
    return this;
  }

  public ProductDataProjection<PARENT, ROOT> slug() {
    getFields().put("slug", null);
    return this;
  }

  public ProductDataProjection slug(String locale, List<String> acceptLanguage) {
    getFields().put("slug", null);
    getInputArguments().computeIfAbsent("slug", k -> new ArrayList<>());
    InputArgument localeArg = new InputArgument("locale", locale);
    getInputArguments().get("slug").add(localeArg);
    InputArgument acceptLanguageArg = new InputArgument("acceptLanguage", acceptLanguage);
    getInputArguments().get("slug").add(acceptLanguageArg);
    return this;
  }

  public ProductDataProjection<PARENT, ROOT> categoryOrderHint() {
    getFields().put("categoryOrderHint", null);
    return this;
  }

  public ProductDataProjection categoryOrderHint(String categoryId) {
    getFields().put("categoryOrderHint", null);
    getInputArguments().computeIfAbsent("categoryOrderHint", k -> new ArrayList<>());
    InputArgument categoryIdArg = new InputArgument("categoryId", categoryId);
    getInputArguments().get("categoryOrderHint").add(categoryIdArg);
    return this;
  }

  public ProductDataProjection<PARENT, ROOT> metaTitle() {
    getFields().put("metaTitle", null);
    return this;
  }

  public ProductDataProjection metaTitle(String locale, List<String> acceptLanguage) {
    getFields().put("metaTitle", null);
    getInputArguments().computeIfAbsent("metaTitle", k -> new ArrayList<>());
    InputArgument localeArg = new InputArgument("locale", locale);
    getInputArguments().get("metaTitle").add(localeArg);
    InputArgument acceptLanguageArg = new InputArgument("acceptLanguage", acceptLanguage);
    getInputArguments().get("metaTitle").add(acceptLanguageArg);
    return this;
  }

  public ProductDataProjection<PARENT, ROOT> metaKeywords() {
    getFields().put("metaKeywords", null);
    return this;
  }

  public ProductDataProjection metaKeywords(String locale, List<String> acceptLanguage) {
    getFields().put("metaKeywords", null);
    getInputArguments().computeIfAbsent("metaKeywords", k -> new ArrayList<>());
    InputArgument localeArg = new InputArgument("locale", locale);
    getInputArguments().get("metaKeywords").add(localeArg);
    InputArgument acceptLanguageArg = new InputArgument("acceptLanguage", acceptLanguage);
    getInputArguments().get("metaKeywords").add(acceptLanguageArg);
    return this;
  }

  public ProductDataProjection<PARENT, ROOT> metaDescription() {
    getFields().put("metaDescription", null);
    return this;
  }

  public ProductDataProjection metaDescription(String locale, List<String> acceptLanguage) {
    getFields().put("metaDescription", null);
    getInputArguments().computeIfAbsent("metaDescription", k -> new ArrayList<>());
    InputArgument localeArg = new InputArgument("locale", locale);
    getInputArguments().get("metaDescription").add(localeArg);
    InputArgument acceptLanguageArg = new InputArgument("acceptLanguage", acceptLanguage);
    getInputArguments().get("metaDescription").add(acceptLanguageArg);
    return this;
  }

  public ProductDataProjection<PARENT, ROOT> skus() {
    getFields().put("skus", null);
    return this;
  }
}
