package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.BaseSubProjectionNode;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;
import java.util.List;

public class ProductFragmentProjection<PARENT extends BaseSubProjectionNode<?, ?>, ROOT extends BaseSubProjectionNode<?, ?>> extends BaseSubProjectionNode<PARENT, ROOT> {
  {
    getFields().put("__typename", null);
  }

  public ProductFragmentProjection(PARENT parent, ROOT root) {
    super(parent, root, java.util.Optional.of("Product"));
  }

  public ProductFragmentProjection<PARENT, ROOT> __typename() {
    getFields().put("__typename", null);
    return this;
  }

  public ReferenceProjection<ProductFragmentProjection<PARENT, ROOT>, ROOT> productTypeRef() {
     ReferenceProjection<ProductFragmentProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("productTypeRef", projection);
     return projection;
  }

  public ProductTypeDefinitionProjection<ProductFragmentProjection<PARENT, ROOT>, ROOT> productType(
      ) {
     ProductTypeDefinitionProjection<ProductFragmentProjection<PARENT, ROOT>, ROOT> projection = new ProductTypeDefinitionProjection<>(this, getRoot());
     getFields().put("productType", projection);
     return projection;
  }

  public ProductCatalogDataProjection<ProductFragmentProjection<PARENT, ROOT>, ROOT> masterData() {
     ProductCatalogDataProjection<ProductFragmentProjection<PARENT, ROOT>, ROOT> projection = new ProductCatalogDataProjection<>(this, getRoot());
     getFields().put("masterData", projection);
     return projection;
  }

  public ReferenceProjection<ProductFragmentProjection<PARENT, ROOT>, ROOT> stateRef() {
     ReferenceProjection<ProductFragmentProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("stateRef", projection);
     return projection;
  }

  public StateProjection<ProductFragmentProjection<PARENT, ROOT>, ROOT> state() {
     StateProjection<ProductFragmentProjection<PARENT, ROOT>, ROOT> projection = new StateProjection<>(this, getRoot());
     getFields().put("state", projection);
     return projection;
  }

  public PriceModeProjection<ProductFragmentProjection<PARENT, ROOT>, ROOT> priceMode() {
     PriceModeProjection<ProductFragmentProjection<PARENT, ROOT>, ROOT> projection = new PriceModeProjection<>(this, getRoot());
     getFields().put("priceMode", projection);
     return projection;
  }

  public ReferenceProjection<ProductFragmentProjection<PARENT, ROOT>, ROOT> taxCategoryRef() {
     ReferenceProjection<ProductFragmentProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("taxCategoryRef", projection);
     return projection;
  }

  public TaxCategoryProjection<ProductFragmentProjection<PARENT, ROOT>, ROOT> taxCategory() {
     TaxCategoryProjection<ProductFragmentProjection<PARENT, ROOT>, ROOT> projection = new TaxCategoryProjection<>(this, getRoot());
     getFields().put("taxCategory", projection);
     return projection;
  }

  public ReviewRatingStatisticsProjection<ProductFragmentProjection<PARENT, ROOT>, ROOT> reviewRatingStatistics(
      ) {
     ReviewRatingStatisticsProjection<ProductFragmentProjection<PARENT, ROOT>, ROOT> projection = new ReviewRatingStatisticsProjection<>(this, getRoot());
     getFields().put("reviewRatingStatistics", projection);
     return projection;
  }

  public SelectionOfProductQueryResultProjection<ProductFragmentProjection<PARENT, ROOT>, ROOT> productSelectionRefs(
      ) {
     SelectionOfProductQueryResultProjection<ProductFragmentProjection<PARENT, ROOT>, ROOT> projection = new SelectionOfProductQueryResultProjection<>(this, getRoot());
     getFields().put("productSelectionRefs", projection);
     return projection;
  }

  public SelectionOfProductQueryResultProjection<ProductFragmentProjection<PARENT, ROOT>, ROOT> productSelectionRefs(
      String where, List<String> sort, Integer limit, Integer offset) {
    SelectionOfProductQueryResultProjection<ProductFragmentProjection<PARENT, ROOT>, ROOT> projection = new SelectionOfProductQueryResultProjection<>(this, getRoot());    
    getFields().put("productSelectionRefs", projection);
    getInputArguments().computeIfAbsent("productSelectionRefs", k -> new ArrayList<>());                      
    InputArgument whereArg = new InputArgument("where", where);
    getInputArguments().get("productSelectionRefs").add(whereArg);
    InputArgument sortArg = new InputArgument("sort", sort);
    getInputArguments().get("productSelectionRefs").add(sortArg);
    InputArgument limitArg = new InputArgument("limit", limit);
    getInputArguments().get("productSelectionRefs").add(limitArg);
    InputArgument offsetArg = new InputArgument("offset", offset);
    getInputArguments().get("productSelectionRefs").add(offsetArg);
    return projection;
  }

  public InitiatorProjection<ProductFragmentProjection<PARENT, ROOT>, ROOT> createdBy() {
     InitiatorProjection<ProductFragmentProjection<PARENT, ROOT>, ROOT> projection = new InitiatorProjection<>(this, getRoot());
     getFields().put("createdBy", projection);
     return projection;
  }

  public InitiatorProjection<ProductFragmentProjection<PARENT, ROOT>, ROOT> lastModifiedBy() {
     InitiatorProjection<ProductFragmentProjection<PARENT, ROOT>, ROOT> projection = new InitiatorProjection<>(this, getRoot());
     getFields().put("lastModifiedBy", projection);
     return projection;
  }

  public ProductFragmentProjection<PARENT, ROOT> id() {
    getFields().put("id", null);
    return this;
  }

  public ProductFragmentProjection<PARENT, ROOT> key() {
    getFields().put("key", null);
    return this;
  }

  public ProductFragmentProjection<PARENT, ROOT> version() {
    getFields().put("version", null);
    return this;
  }

  public ProductFragmentProjection<PARENT, ROOT> skus() {
    getFields().put("skus", null);
    return this;
  }

  public ProductFragmentProjection<PARENT, ROOT> createdAt() {
    getFields().put("createdAt", null);
    return this;
  }

  public ProductFragmentProjection<PARENT, ROOT> lastModifiedAt() {
    getFields().put("lastModifiedAt", null);
    return this;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    builder.append("... on Product {");
    getFields().forEach((k, v) -> {
        builder.append(" ").append(k);
        if(v != null) {
            builder.append(" ").append(v.toString());
        }
    });
    builder.append("}");
     
    return builder.toString();
  }
}
