package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Boolean;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ProductGraphQLQuery extends GraphQLQuery {
  public ProductGraphQLQuery(Boolean projectExpandedProducts, List<String> localeProjection,
      String sku, String variantKey, String id, String key, String queryName,
      Set<String> fieldsSet) {
    super("query", queryName);
    if (projectExpandedProducts != null || fieldsSet.contains("projectExpandedProducts")) {
        getInput().put("projectExpandedProducts", projectExpandedProducts);
    }if (localeProjection != null || fieldsSet.contains("localeProjection")) {
        getInput().put("localeProjection", localeProjection);
    }if (sku != null || fieldsSet.contains("sku")) {
        getInput().put("sku", sku);
    }if (variantKey != null || fieldsSet.contains("variantKey")) {
        getInput().put("variantKey", variantKey);
    }if (id != null || fieldsSet.contains("id")) {
        getInput().put("id", id);
    }if (key != null || fieldsSet.contains("key")) {
        getInput().put("key", key);
    }
  }

  public ProductGraphQLQuery() {
    super("query");
  }

  @Override
  public String getOperationName() {
    return "product";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private Boolean projectExpandedProducts;

    private List<String> localeProjection;

    private String sku;

    private String variantKey;

    private String id;

    private String key;

    private String queryName;

    public ProductGraphQLQuery build() {
      return new ProductGraphQLQuery(projectExpandedProducts, localeProjection, sku, variantKey, id, key, queryName, fieldsSet);
               
    }

    public Builder projectExpandedProducts(Boolean projectExpandedProducts) {
      this.projectExpandedProducts = projectExpandedProducts;
      this.fieldsSet.add("projectExpandedProducts");
      return this;
    }

    public Builder localeProjection(List<String> localeProjection) {
      this.localeProjection = localeProjection;
      this.fieldsSet.add("localeProjection");
      return this;
    }

    /**
     * Queries for a product with specified SKU
     */
    public Builder sku(String sku) {
      this.sku = sku;
      this.fieldsSet.add("sku");
      return this;
    }

    /**
     * Queries for a [Product](https://docs.commercetools.com/api/projects/products#product) with specified [ProductVariant](https://docs.commercetools.com/api/projects/products#productvariant) `key`
     */
    public Builder variantKey(String variantKey) {
      this.variantKey = variantKey;
      this.fieldsSet.add("variantKey");
      return this;
    }

    /**
     * Queries with specified ID
     */
    public Builder id(String id) {
      this.id = id;
      this.fieldsSet.add("id");
      return this;
    }

    /**
     * Queries with specified key
     */
    public Builder key(String key) {
      this.key = key;
      this.fieldsSet.add("key");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
