package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.BaseSubProjectionNode;
import java.lang.Integer;
import java.lang.String;
import java.util.ArrayList;
import java.util.List;

public class ProductProjection<PARENT extends BaseSubProjectionNode<?, ?>, ROOT extends BaseSubProjectionNode<?, ?>> extends BaseSubProjectionNode<PARENT, ROOT> {
  public ProductProjection(PARENT parent, ROOT root) {
    super(parent, root, java.util.Optional.of("Product"));
  }

  public ProductProjection<PARENT, ROOT> __typename() {
    getFields().put("__typename", null);
    return this;
  }

  public ReferenceProjection<ProductProjection<PARENT, ROOT>, ROOT> productTypeRef() {
     ReferenceProjection<ProductProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("productTypeRef", projection);
     return projection;
  }

  public ProductTypeDefinitionProjection<ProductProjection<PARENT, ROOT>, ROOT> productType() {
     ProductTypeDefinitionProjection<ProductProjection<PARENT, ROOT>, ROOT> projection = new ProductTypeDefinitionProjection<>(this, getRoot());
     getFields().put("productType", projection);
     return projection;
  }

  public ProductCatalogDataProjection<ProductProjection<PARENT, ROOT>, ROOT> masterData() {
     ProductCatalogDataProjection<ProductProjection<PARENT, ROOT>, ROOT> projection = new ProductCatalogDataProjection<>(this, getRoot());
     getFields().put("masterData", projection);
     return projection;
  }

  public ReferenceProjection<ProductProjection<PARENT, ROOT>, ROOT> stateRef() {
     ReferenceProjection<ProductProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("stateRef", projection);
     return projection;
  }

  public StateProjection<ProductProjection<PARENT, ROOT>, ROOT> state() {
     StateProjection<ProductProjection<PARENT, ROOT>, ROOT> projection = new StateProjection<>(this, getRoot());
     getFields().put("state", projection);
     return projection;
  }

  public PriceModeProjection<ProductProjection<PARENT, ROOT>, ROOT> priceMode() {
     PriceModeProjection<ProductProjection<PARENT, ROOT>, ROOT> projection = new PriceModeProjection<>(this, getRoot());
     getFields().put("priceMode", projection);
     return projection;
  }

  public ReferenceProjection<ProductProjection<PARENT, ROOT>, ROOT> taxCategoryRef() {
     ReferenceProjection<ProductProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("taxCategoryRef", projection);
     return projection;
  }

  public TaxCategoryProjection<ProductProjection<PARENT, ROOT>, ROOT> taxCategory() {
     TaxCategoryProjection<ProductProjection<PARENT, ROOT>, ROOT> projection = new TaxCategoryProjection<>(this, getRoot());
     getFields().put("taxCategory", projection);
     return projection;
  }

  public ReviewRatingStatisticsProjection<ProductProjection<PARENT, ROOT>, ROOT> reviewRatingStatistics(
      ) {
     ReviewRatingStatisticsProjection<ProductProjection<PARENT, ROOT>, ROOT> projection = new ReviewRatingStatisticsProjection<>(this, getRoot());
     getFields().put("reviewRatingStatistics", projection);
     return projection;
  }

  public SelectionOfProductQueryResultProjection<ProductProjection<PARENT, ROOT>, ROOT> productSelectionRefs(
      ) {
     SelectionOfProductQueryResultProjection<ProductProjection<PARENT, ROOT>, ROOT> projection = new SelectionOfProductQueryResultProjection<>(this, getRoot());
     getFields().put("productSelectionRefs", projection);
     return projection;
  }

  public SelectionOfProductQueryResultProjection<ProductProjection<PARENT, ROOT>, ROOT> productSelectionRefs(
      String where, List<String> sort, Integer limit, Integer offset) {
    SelectionOfProductQueryResultProjection<ProductProjection<PARENT, ROOT>, ROOT> projection = new SelectionOfProductQueryResultProjection<>(this, getRoot());    
    getFields().put("productSelectionRefs", projection);
    getInputArguments().computeIfAbsent("productSelectionRefs", k -> new ArrayList<>());                      
    InputArgument whereArg = new InputArgument("where", where);
    getInputArguments().get("productSelectionRefs").add(whereArg);
    InputArgument sortArg = new InputArgument("sort", sort);
    getInputArguments().get("productSelectionRefs").add(sortArg);
    InputArgument limitArg = new InputArgument("limit", limit);
    getInputArguments().get("productSelectionRefs").add(limitArg);
    InputArgument offsetArg = new InputArgument("offset", offset);
    getInputArguments().get("productSelectionRefs").add(offsetArg);
    return projection;
  }

  public InitiatorProjection<ProductProjection<PARENT, ROOT>, ROOT> createdBy() {
     InitiatorProjection<ProductProjection<PARENT, ROOT>, ROOT> projection = new InitiatorProjection<>(this, getRoot());
     getFields().put("createdBy", projection);
     return projection;
  }

  public InitiatorProjection<ProductProjection<PARENT, ROOT>, ROOT> lastModifiedBy() {
     InitiatorProjection<ProductProjection<PARENT, ROOT>, ROOT> projection = new InitiatorProjection<>(this, getRoot());
     getFields().put("lastModifiedBy", projection);
     return projection;
  }

  public ProductProjection<PARENT, ROOT> id() {
    getFields().put("id", null);
    return this;
  }

  public ProductProjection<PARENT, ROOT> key() {
    getFields().put("key", null);
    return this;
  }

  public ProductProjection<PARENT, ROOT> version() {
    getFields().put("version", null);
    return this;
  }

  public ProductProjection<PARENT, ROOT> skus() {
    getFields().put("skus", null);
    return this;
  }

  public ProductProjection<PARENT, ROOT> createdAt() {
    getFields().put("createdAt", null);
    return this;
  }

  public ProductProjection<PARENT, ROOT> lastModifiedAt() {
    getFields().put("lastModifiedAt", null);
    return this;
  }
}
