package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.BaseSubProjectionNode;
import java.lang.Integer;
import java.lang.String;
import java.util.ArrayList;
import java.util.List;

public class ProductProjectionRoot<PARENT extends BaseSubProjectionNode<?, ?>, ROOT extends BaseSubProjectionNode<?, ?>> extends BaseSubProjectionNode<PARENT, ROOT> {
  public ProductProjectionRoot() {
    super(null, null, java.util.Optional.of("Product"));
  }

  public ProductProjectionRoot<PARENT, ROOT> __typename() {
    getFields().put("__typename", null);
    return this;
  }

  public ReferenceProjection<ProductProjectionRoot<PARENT, ROOT>, ProductProjectionRoot<PARENT, ROOT>> productTypeRef(
      ) {
    ReferenceProjection<ProductProjectionRoot<PARENT, ROOT>, ProductProjectionRoot<PARENT, ROOT>> projection = new ReferenceProjection<>(this, this);    
    getFields().put("productTypeRef", projection);
    return projection;
  }

  public ProductTypeDefinitionProjection<ProductProjectionRoot<PARENT, ROOT>, ProductProjectionRoot<PARENT, ROOT>> productType(
      ) {
    ProductTypeDefinitionProjection<ProductProjectionRoot<PARENT, ROOT>, ProductProjectionRoot<PARENT, ROOT>> projection = new ProductTypeDefinitionProjection<>(this, this);    
    getFields().put("productType", projection);
    return projection;
  }

  public ProductCatalogDataProjection<ProductProjectionRoot<PARENT, ROOT>, ProductProjectionRoot<PARENT, ROOT>> masterData(
      ) {
    ProductCatalogDataProjection<ProductProjectionRoot<PARENT, ROOT>, ProductProjectionRoot<PARENT, ROOT>> projection = new ProductCatalogDataProjection<>(this, this);    
    getFields().put("masterData", projection);
    return projection;
  }

  public ReferenceProjection<ProductProjectionRoot<PARENT, ROOT>, ProductProjectionRoot<PARENT, ROOT>> stateRef(
      ) {
    ReferenceProjection<ProductProjectionRoot<PARENT, ROOT>, ProductProjectionRoot<PARENT, ROOT>> projection = new ReferenceProjection<>(this, this);    
    getFields().put("stateRef", projection);
    return projection;
  }

  public StateProjection<ProductProjectionRoot<PARENT, ROOT>, ProductProjectionRoot<PARENT, ROOT>> state(
      ) {
    StateProjection<ProductProjectionRoot<PARENT, ROOT>, ProductProjectionRoot<PARENT, ROOT>> projection = new StateProjection<>(this, this);    
    getFields().put("state", projection);
    return projection;
  }

  public PriceModeProjection<ProductProjectionRoot<PARENT, ROOT>, ProductProjectionRoot<PARENT, ROOT>> priceMode(
      ) {
    PriceModeProjection<ProductProjectionRoot<PARENT, ROOT>, ProductProjectionRoot<PARENT, ROOT>> projection = new PriceModeProjection<>(this, this);    
    getFields().put("priceMode", projection);
    return projection;
  }

  public ReferenceProjection<ProductProjectionRoot<PARENT, ROOT>, ProductProjectionRoot<PARENT, ROOT>> taxCategoryRef(
      ) {
    ReferenceProjection<ProductProjectionRoot<PARENT, ROOT>, ProductProjectionRoot<PARENT, ROOT>> projection = new ReferenceProjection<>(this, this);    
    getFields().put("taxCategoryRef", projection);
    return projection;
  }

  public TaxCategoryProjection<ProductProjectionRoot<PARENT, ROOT>, ProductProjectionRoot<PARENT, ROOT>> taxCategory(
      ) {
    TaxCategoryProjection<ProductProjectionRoot<PARENT, ROOT>, ProductProjectionRoot<PARENT, ROOT>> projection = new TaxCategoryProjection<>(this, this);    
    getFields().put("taxCategory", projection);
    return projection;
  }

  public ReviewRatingStatisticsProjection<ProductProjectionRoot<PARENT, ROOT>, ProductProjectionRoot<PARENT, ROOT>> reviewRatingStatistics(
      ) {
    ReviewRatingStatisticsProjection<ProductProjectionRoot<PARENT, ROOT>, ProductProjectionRoot<PARENT, ROOT>> projection = new ReviewRatingStatisticsProjection<>(this, this);    
    getFields().put("reviewRatingStatistics", projection);
    return projection;
  }

  public SelectionOfProductQueryResultProjection<ProductProjectionRoot<PARENT, ROOT>, ProductProjectionRoot<PARENT, ROOT>> productSelectionRefs(
      ) {
    SelectionOfProductQueryResultProjection<ProductProjectionRoot<PARENT, ROOT>, ProductProjectionRoot<PARENT, ROOT>> projection = new SelectionOfProductQueryResultProjection<>(this, this);    
    getFields().put("productSelectionRefs", projection);
    return projection;
  }

  public SelectionOfProductQueryResultProjection<ProductProjectionRoot<PARENT, ROOT>, ProductProjectionRoot<PARENT, ROOT>> productSelectionRefs(
      String where, List<String> sort, Integer limit, Integer offset) {
    SelectionOfProductQueryResultProjection<ProductProjectionRoot<PARENT, ROOT>, ProductProjectionRoot<PARENT, ROOT>> projection = new SelectionOfProductQueryResultProjection<>(this, this);    
    getFields().put("productSelectionRefs", projection);
    getInputArguments().computeIfAbsent("productSelectionRefs", k -> new ArrayList<>());                      
    InputArgument whereArg = new InputArgument("where", where);
    getInputArguments().get("productSelectionRefs").add(whereArg);
    InputArgument sortArg = new InputArgument("sort", sort);
    getInputArguments().get("productSelectionRefs").add(sortArg);
    InputArgument limitArg = new InputArgument("limit", limit);
    getInputArguments().get("productSelectionRefs").add(limitArg);
    InputArgument offsetArg = new InputArgument("offset", offset);
    getInputArguments().get("productSelectionRefs").add(offsetArg);
    return projection;
  }

  public InitiatorProjection<ProductProjectionRoot<PARENT, ROOT>, ProductProjectionRoot<PARENT, ROOT>> createdBy(
      ) {
    InitiatorProjection<ProductProjectionRoot<PARENT, ROOT>, ProductProjectionRoot<PARENT, ROOT>> projection = new InitiatorProjection<>(this, this);    
    getFields().put("createdBy", projection);
    return projection;
  }

  public InitiatorProjection<ProductProjectionRoot<PARENT, ROOT>, ProductProjectionRoot<PARENT, ROOT>> lastModifiedBy(
      ) {
    InitiatorProjection<ProductProjectionRoot<PARENT, ROOT>, ProductProjectionRoot<PARENT, ROOT>> projection = new InitiatorProjection<>(this, this);    
    getFields().put("lastModifiedBy", projection);
    return projection;
  }

  public ProductProjectionRoot<PARENT, ROOT> id() {
    getFields().put("id", null);
    return this;
  }

  public ProductProjectionRoot<PARENT, ROOT> key() {
    getFields().put("key", null);
    return this;
  }

  public ProductProjectionRoot<PARENT, ROOT> version() {
    getFields().put("version", null);
    return this;
  }

  public ProductProjectionRoot<PARENT, ROOT> skus() {
    getFields().put("skus", null);
    return this;
  }

  public ProductProjectionRoot<PARENT, ROOT> createdAt() {
    getFields().put("createdAt", null);
    return this;
  }

  public ProductProjectionRoot<PARENT, ROOT> lastModifiedAt() {
    getFields().put("lastModifiedAt", null);
    return this;
  }
}
