package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.PriceSelectorInput;
import com.commercetools.graphql.api.types.SearchFacetInput;
import com.commercetools.graphql.api.types.SearchFilterInput;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ProductProjectionSearchGraphQLQuery extends GraphQLQuery {
  public ProductProjectionSearchGraphQLQuery(Boolean projectExpandedProducts, String locale,
      String text, List<SearchFacetInput> facets, List<SearchFilterInput> filters,
      List<SearchFilterInput> queryFilters, List<SearchFilterInput> facetFilters,
      List<String> sorts, Integer limit, Integer offset, Boolean fuzzy, Integer fuzzyLevel,
      PriceSelectorInput priceSelector, Boolean markMatchingVariants, Boolean markMatchingVariant,
      String storeProjection, List<String> localeProjection, Boolean staged, String queryName,
      Set<String> fieldsSet) {
    super("query", queryName);
    if (projectExpandedProducts != null || fieldsSet.contains("projectExpandedProducts")) {
        getInput().put("projectExpandedProducts", projectExpandedProducts);
    }if (locale != null || fieldsSet.contains("locale")) {
        getInput().put("locale", locale);
    }if (text != null || fieldsSet.contains("text")) {
        getInput().put("text", text);
    }if (facets != null || fieldsSet.contains("facets")) {
        getInput().put("facets", facets);
    }if (filters != null || fieldsSet.contains("filters")) {
        getInput().put("filters", filters);
    }if (queryFilters != null || fieldsSet.contains("queryFilters")) {
        getInput().put("queryFilters", queryFilters);
    }if (facetFilters != null || fieldsSet.contains("facetFilters")) {
        getInput().put("facetFilters", facetFilters);
    }if (sorts != null || fieldsSet.contains("sorts")) {
        getInput().put("sorts", sorts);
    }if (limit != null || fieldsSet.contains("limit")) {
        getInput().put("limit", limit);
    }if (offset != null || fieldsSet.contains("offset")) {
        getInput().put("offset", offset);
    }if (fuzzy != null || fieldsSet.contains("fuzzy")) {
        getInput().put("fuzzy", fuzzy);
    }if (fuzzyLevel != null || fieldsSet.contains("fuzzyLevel")) {
        getInput().put("fuzzyLevel", fuzzyLevel);
    }if (priceSelector != null || fieldsSet.contains("priceSelector")) {
        getInput().put("priceSelector", priceSelector);
    }if (markMatchingVariants != null || fieldsSet.contains("markMatchingVariants")) {
        getInput().put("markMatchingVariants", markMatchingVariants);
    }if (markMatchingVariant != null || fieldsSet.contains("markMatchingVariant")) {
        getInput().put("markMatchingVariant", markMatchingVariant);
    }if (storeProjection != null || fieldsSet.contains("storeProjection")) {
        getInput().put("storeProjection", storeProjection);
    }if (localeProjection != null || fieldsSet.contains("localeProjection")) {
        getInput().put("localeProjection", localeProjection);
    }if (staged != null || fieldsSet.contains("staged")) {
        getInput().put("staged", staged);
    }
  }

  public ProductProjectionSearchGraphQLQuery() {
    super("query");
  }

  @Override
  public String getOperationName() {
    return "productProjectionSearch";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private Boolean projectExpandedProducts;

    private String locale;

    private String text;

    private List<SearchFacetInput> facets;

    private List<SearchFilterInput> filters;

    private List<SearchFilterInput> queryFilters;

    private List<SearchFilterInput> facetFilters;

    private List<String> sorts;

    private Integer limit;

    private Integer offset;

    private Boolean fuzzy;

    private Integer fuzzyLevel;

    private PriceSelectorInput priceSelector;

    private Boolean markMatchingVariants;

    private Boolean markMatchingVariant;

    private String storeProjection;

    private List<String> localeProjection;

    private Boolean staged;

    private String queryName;

    public ProductProjectionSearchGraphQLQuery build() {
      return new ProductProjectionSearchGraphQLQuery(projectExpandedProducts, locale, text, facets, filters, queryFilters, facetFilters, sorts, limit, offset, fuzzy, fuzzyLevel, priceSelector, markMatchingVariants, markMatchingVariant, storeProjection, localeProjection, staged, queryName, fieldsSet);
               
    }

    public Builder projectExpandedProducts(Boolean projectExpandedProducts) {
      this.projectExpandedProducts = projectExpandedProducts;
      this.fieldsSet.add("projectExpandedProducts");
      return this;
    }

    public Builder locale(String locale) {
      this.locale = locale;
      this.fieldsSet.add("locale");
      return this;
    }

    public Builder text(String text) {
      this.text = text;
      this.fieldsSet.add("text");
      return this;
    }

    public Builder facets(List<SearchFacetInput> facets) {
      this.facets = facets;
      this.fieldsSet.add("facets");
      return this;
    }

    public Builder filters(List<SearchFilterInput> filters) {
      this.filters = filters;
      this.fieldsSet.add("filters");
      return this;
    }

    public Builder queryFilters(List<SearchFilterInput> queryFilters) {
      this.queryFilters = queryFilters;
      this.fieldsSet.add("queryFilters");
      return this;
    }

    public Builder facetFilters(List<SearchFilterInput> facetFilters) {
      this.facetFilters = facetFilters;
      this.fieldsSet.add("facetFilters");
      return this;
    }

    public Builder sorts(List<String> sorts) {
      this.sorts = sorts;
      this.fieldsSet.add("sorts");
      return this;
    }

    public Builder limit(Integer limit) {
      this.limit = limit;
      this.fieldsSet.add("limit");
      return this;
    }

    public Builder offset(Integer offset) {
      this.offset = offset;
      this.fieldsSet.add("offset");
      return this;
    }

    public Builder fuzzy(Boolean fuzzy) {
      this.fuzzy = fuzzy;
      this.fieldsSet.add("fuzzy");
      return this;
    }

    public Builder fuzzyLevel(Integer fuzzyLevel) {
      this.fuzzyLevel = fuzzyLevel;
      this.fieldsSet.add("fuzzyLevel");
      return this;
    }

    public Builder priceSelector(PriceSelectorInput priceSelector) {
      this.priceSelector = priceSelector;
      this.fieldsSet.add("priceSelector");
      return this;
    }

    public Builder markMatchingVariants(Boolean markMatchingVariants) {
      this.markMatchingVariants = markMatchingVariants;
      this.fieldsSet.add("markMatchingVariants");
      return this;
    }

    /**
     * Deprecated: please use 'markMatchingVariants'.
     */
    public Builder markMatchingVariant(Boolean markMatchingVariant) {
      this.markMatchingVariant = markMatchingVariant;
      this.fieldsSet.add("markMatchingVariant");
      return this;
    }

    public Builder storeProjection(String storeProjection) {
      this.storeProjection = storeProjection;
      this.fieldsSet.add("storeProjection");
      return this;
    }

    public Builder localeProjection(List<String> localeProjection) {
      this.localeProjection = localeProjection;
      this.fieldsSet.add("localeProjection");
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      this.fieldsSet.add("staged");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
