package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.BaseSubProjectionNode;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Currency;
import java.util.List;

public class ProductSearchVariantProjection<PARENT extends BaseSubProjectionNode<?, ?>, ROOT extends BaseSubProjectionNode<?, ?>> extends BaseSubProjectionNode<PARENT, ROOT> {
  public ProductSearchVariantProjection(PARENT parent, ROOT root) {
    super(parent, root, java.util.Optional.of("ProductSearchVariant"));
  }

  public ProductSearchVariantProjection<PARENT, ROOT> __typename() {
    getFields().put("__typename", null);
    return this;
  }

  public ProductPriceSearchProjection<ProductSearchVariantProjection<PARENT, ROOT>, ROOT> prices() {
     ProductPriceSearchProjection<ProductSearchVariantProjection<PARENT, ROOT>, ROOT> projection = new ProductPriceSearchProjection<>(this, getRoot());
     getFields().put("prices", projection);
     return projection;
  }

  public ProductPriceSearchProjection<ProductSearchVariantProjection<PARENT, ROOT>, ROOT> price() {
     ProductPriceSearchProjection<ProductSearchVariantProjection<PARENT, ROOT>, ROOT> projection = new ProductPriceSearchProjection<>(this, getRoot());
     getFields().put("price", projection);
     return projection;
  }

  public ProductPriceSearchProjection<ProductSearchVariantProjection<PARENT, ROOT>, ROOT> price(
      Currency currency, String country, String customerGroupId, String channelId,
      OffsetDateTime date) {
    ProductPriceSearchProjection<ProductSearchVariantProjection<PARENT, ROOT>, ROOT> projection = new ProductPriceSearchProjection<>(this, getRoot());    
    getFields().put("price", projection);
    getInputArguments().computeIfAbsent("price", k -> new ArrayList<>());                      
    InputArgument currencyArg = new InputArgument("currency", currency);
    getInputArguments().get("price").add(currencyArg);
    InputArgument countryArg = new InputArgument("country", country);
    getInputArguments().get("price").add(countryArg);
    InputArgument customerGroupIdArg = new InputArgument("customerGroupId", customerGroupId);
    getInputArguments().get("price").add(customerGroupIdArg);
    InputArgument channelIdArg = new InputArgument("channelId", channelId);
    getInputArguments().get("price").add(channelIdArg);
    InputArgument dateArg = new InputArgument("date", date);
    getInputArguments().get("price").add(dateArg);
    return projection;
  }

  public ImageProductSearchProjection<ProductSearchVariantProjection<PARENT, ROOT>, ROOT> images() {
     ImageProductSearchProjection<ProductSearchVariantProjection<PARENT, ROOT>, ROOT> projection = new ImageProductSearchProjection<>(this, getRoot());
     getFields().put("images", projection);
     return projection;
  }

  public AssetProjection<ProductSearchVariantProjection<PARENT, ROOT>, ROOT> assets() {
     AssetProjection<ProductSearchVariantProjection<PARENT, ROOT>, ROOT> projection = new AssetProjection<>(this, getRoot());
     getFields().put("assets", projection);
     return projection;
  }

  public ProductSearchVariantAvailabilityWithChannelsProjection<ProductSearchVariantProjection<PARENT, ROOT>, ROOT> availability(
      ) {
     ProductSearchVariantAvailabilityWithChannelsProjection<ProductSearchVariantProjection<PARENT, ROOT>, ROOT> projection = new ProductSearchVariantAvailabilityWithChannelsProjection<>(this, getRoot());
     getFields().put("availability", projection);
     return projection;
  }

  public RawProductSearchAttributeProjection<ProductSearchVariantProjection<PARENT, ROOT>, ROOT> attributesRaw(
      ) {
     RawProductSearchAttributeProjection<ProductSearchVariantProjection<PARENT, ROOT>, ROOT> projection = new RawProductSearchAttributeProjection<>(this, getRoot());
     getFields().put("attributesRaw", projection);
     return projection;
  }

  public RawProductSearchAttributeProjection<ProductSearchVariantProjection<PARENT, ROOT>, ROOT> attributesRaw(
      List<String> includeNames, List<String> excludeNames) {
    RawProductSearchAttributeProjection<ProductSearchVariantProjection<PARENT, ROOT>, ROOT> projection = new RawProductSearchAttributeProjection<>(this, getRoot());    
    getFields().put("attributesRaw", projection);
    getInputArguments().computeIfAbsent("attributesRaw", k -> new ArrayList<>());                      
    InputArgument includeNamesArg = new InputArgument("includeNames", includeNames);
    getInputArguments().get("attributesRaw").add(includeNamesArg);
    InputArgument excludeNamesArg = new InputArgument("excludeNames", excludeNames);
    getInputArguments().get("attributesRaw").add(excludeNamesArg);
    return projection;
  }

  public ScopedPriceProjection<ProductSearchVariantProjection<PARENT, ROOT>, ROOT> scopedPrice() {
     ScopedPriceProjection<ProductSearchVariantProjection<PARENT, ROOT>, ROOT> projection = new ScopedPriceProjection<>(this, getRoot());
     getFields().put("scopedPrice", projection);
     return projection;
  }

  public ProductSearchVariantProjection<PARENT, ROOT> id() {
    getFields().put("id", null);
    return this;
  }

  public ProductSearchVariantProjection<PARENT, ROOT> key() {
    getFields().put("key", null);
    return this;
  }

  public ProductSearchVariantProjection<PARENT, ROOT> sku() {
    getFields().put("sku", null);
    return this;
  }

  public ProductSearchVariantProjection<PARENT, ROOT> isMatchingVariant() {
    getFields().put("isMatchingVariant", null);
    return this;
  }

  public ProductSearchVariantProjection<PARENT, ROOT> scopedPriceDiscounted() {
    getFields().put("scopedPriceDiscounted", null);
    return this;
  }
}
