package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

public class ProductTailoringGraphQLQuery extends GraphQLQuery {
  public ProductTailoringGraphQLQuery(String id, String key, String productId, String productKey,
      String storeKey, String queryName, Set<String> fieldsSet) {
    super("query", queryName);
    if (id != null || fieldsSet.contains("id")) {
        getInput().put("id", id);
    }if (key != null || fieldsSet.contains("key")) {
        getInput().put("key", key);
    }if (productId != null || fieldsSet.contains("productId")) {
        getInput().put("productId", productId);
    }if (productKey != null || fieldsSet.contains("productKey")) {
        getInput().put("productKey", productKey);
    }if (storeKey != null || fieldsSet.contains("storeKey")) {
        getInput().put("storeKey", storeKey);
    }
  }

  public ProductTailoringGraphQLQuery() {
    super("query");
  }

  @Override
  public String getOperationName() {
    return "productTailoring";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private String id;

    private String key;

    private String productId;

    private String productKey;

    private String storeKey;

    private String queryName;

    public ProductTailoringGraphQLQuery build() {
      return new ProductTailoringGraphQLQuery(id, key, productId, productKey, storeKey, queryName, fieldsSet);
               
    }

    /**
     * Queries with specified ID
     */
    public Builder id(String id) {
      this.id = id;
      this.fieldsSet.add("id");
      return this;
    }

    /**
     * Queries with specified key
     */
    public Builder key(String key) {
      this.key = key;
      this.fieldsSet.add("key");
      return this;
    }

    /**
     * Queries with specified Product ID
     */
    public Builder productId(String productId) {
      this.productId = productId;
      this.fieldsSet.add("productId");
      return this;
    }

    /**
     * Queries with specified Product key
     */
    public Builder productKey(String productKey) {
      this.productKey = productKey;
      this.fieldsSet.add("productKey");
      return this;
    }

    /**
     * The mutation is only performed if the resource is part of the store. Can be used with store-specific OAuth permissions.
     */
    public Builder storeKey(String storeKey) {
      this.storeKey = storeKey;
      this.fieldsSet.add("storeKey");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
