package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.BaseSubProjectionNode;
import java.lang.String;
import java.util.ArrayList;

public class QuoteProjectionRoot<PARENT extends BaseSubProjectionNode<?, ?>, ROOT extends BaseSubProjectionNode<?, ?>> extends BaseSubProjectionNode<PARENT, ROOT> {
  public QuoteProjectionRoot() {
    super(null, null, java.util.Optional.of("Quote"));
  }

  public QuoteProjectionRoot<PARENT, ROOT> __typename() {
    getFields().put("__typename", null);
    return this;
  }

  public ReferenceProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> customerRef(
      ) {
    ReferenceProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new ReferenceProjection<>(this, this);    
    getFields().put("customerRef", projection);
    return projection;
  }

  public CustomerProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> customer(
      ) {
    CustomerProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new CustomerProjection<>(this, this);    
    getFields().put("customer", projection);
    return projection;
  }

  public ReferenceProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> customerGroupRef(
      ) {
    ReferenceProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new ReferenceProjection<>(this, this);    
    getFields().put("customerGroupRef", projection);
    return projection;
  }

  public CustomerGroupProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> customerGroup(
      ) {
    CustomerGroupProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new CustomerGroupProjection<>(this, this);    
    getFields().put("customerGroup", projection);
    return projection;
  }

  public LineItemProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> lineItems(
      ) {
    LineItemProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new LineItemProjection<>(this, this);    
    getFields().put("lineItems", projection);
    return projection;
  }

  public LineItemProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> lineItems(
      String id) {
    LineItemProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new LineItemProjection<>(this, this);    
    getFields().put("lineItems", projection);
    getInputArguments().computeIfAbsent("lineItems", k -> new ArrayList<>());                      
    InputArgument idArg = new InputArgument("id", id);
    getInputArguments().get("lineItems").add(idArg);
    return projection;
  }

  public CustomLineItemProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> customLineItems(
      ) {
    CustomLineItemProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new CustomLineItemProjection<>(this, this);    
    getFields().put("customLineItems", projection);
    return projection;
  }

  public MoneyProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> totalPrice(
      ) {
    MoneyProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new MoneyProjection<>(this, this);    
    getFields().put("totalPrice", projection);
    return projection;
  }

  public TaxedPriceProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> taxedPrice(
      ) {
    TaxedPriceProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new TaxedPriceProjection<>(this, this);    
    getFields().put("taxedPrice", projection);
    return projection;
  }

  public AddressProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> shippingAddress(
      ) {
    AddressProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new AddressProjection<>(this, this);    
    getFields().put("shippingAddress", projection);
    return projection;
  }

  public AddressProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> billingAddress(
      ) {
    AddressProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new AddressProjection<>(this, this);    
    getFields().put("billingAddress", projection);
    return projection;
  }

  public AddressProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> itemShippingAddresses(
      ) {
    AddressProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new AddressProjection<>(this, this);    
    getFields().put("itemShippingAddresses", projection);
    return projection;
  }

  public InventoryModeProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> inventoryMode(
      ) {
    InventoryModeProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new InventoryModeProjection<>(this, this);    
    getFields().put("inventoryMode", projection);
    return projection;
  }

  public TaxModeProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> taxMode(
      ) {
    TaxModeProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new TaxModeProjection<>(this, this);    
    getFields().put("taxMode", projection);
    return projection;
  }

  public RoundingModeProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> taxRoundingMode(
      ) {
    RoundingModeProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new RoundingModeProjection<>(this, this);    
    getFields().put("taxRoundingMode", projection);
    return projection;
  }

  public TaxCalculationModeProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> taxCalculationMode(
      ) {
    TaxCalculationModeProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new TaxCalculationModeProjection<>(this, this);    
    getFields().put("taxCalculationMode", projection);
    return projection;
  }

  public ShippingInfoProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> shippingInfo(
      ) {
    ShippingInfoProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new ShippingInfoProjection<>(this, this);    
    getFields().put("shippingInfo", projection);
    return projection;
  }

  public PaymentInfoProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> paymentInfo(
      ) {
    PaymentInfoProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new PaymentInfoProjection<>(this, this);    
    getFields().put("paymentInfo", projection);
    return projection;
  }

  public DirectDiscountProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> directDiscounts(
      ) {
    DirectDiscountProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new DirectDiscountProjection<>(this, this);    
    getFields().put("directDiscounts", projection);
    return projection;
  }

  public ShippingRateInputProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> shippingRateInput(
      ) {
    ShippingRateInputProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new ShippingRateInputProjection<>(this, this);    
    getFields().put("shippingRateInput", projection);
    return projection;
  }

  public KeyReferenceProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> storeRef(
      ) {
    KeyReferenceProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new KeyReferenceProjection<>(this, this);    
    getFields().put("storeRef", projection);
    return projection;
  }

  public StoreProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> store(
      ) {
    StoreProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new StoreProjection<>(this, this);    
    getFields().put("store", projection);
    return projection;
  }

  public BusinessUnitProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> businessUnit(
      ) {
    BusinessUnitProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new BusinessUnitProjection<>(this, this);    
    getFields().put("businessUnit", projection);
    return projection;
  }

  public KeyReferenceProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> businessUnitRef(
      ) {
    KeyReferenceProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new KeyReferenceProjection<>(this, this);    
    getFields().put("businessUnitRef", projection);
    return projection;
  }

  public QuoteStateProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> quoteState(
      ) {
    QuoteStateProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new QuoteStateProjection<>(this, this);    
    getFields().put("quoteState", projection);
    return projection;
  }

  public ReferenceProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> stagedQuoteRef(
      ) {
    ReferenceProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new ReferenceProjection<>(this, this);    
    getFields().put("stagedQuoteRef", projection);
    return projection;
  }

  public StagedQuoteProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> stagedQuote(
      ) {
    StagedQuoteProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new StagedQuoteProjection<>(this, this);    
    getFields().put("stagedQuote", projection);
    return projection;
  }

  public ReferenceProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> quoteRequestRef(
      ) {
    ReferenceProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new ReferenceProjection<>(this, this);    
    getFields().put("quoteRequestRef", projection);
    return projection;
  }

  public QuoteRequestProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> quoteRequest(
      ) {
    QuoteRequestProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new QuoteRequestProjection<>(this, this);    
    getFields().put("quoteRequest", projection);
    return projection;
  }

  public CustomFieldsTypeProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> custom(
      ) {
    CustomFieldsTypeProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new CustomFieldsTypeProjection<>(this, this);    
    getFields().put("custom", projection);
    return projection;
  }

  public ReferenceProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> stateRef(
      ) {
    ReferenceProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new ReferenceProjection<>(this, this);    
    getFields().put("stateRef", projection);
    return projection;
  }

  public StateProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> state(
      ) {
    StateProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new StateProjection<>(this, this);    
    getFields().put("state", projection);
    return projection;
  }

  public InitiatorProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> createdBy(
      ) {
    InitiatorProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new InitiatorProjection<>(this, this);    
    getFields().put("createdBy", projection);
    return projection;
  }

  public InitiatorProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> lastModifiedBy(
      ) {
    InitiatorProjection<QuoteProjectionRoot<PARENT, ROOT>, QuoteProjectionRoot<PARENT, ROOT>> projection = new InitiatorProjection<>(this, this);    
    getFields().put("lastModifiedBy", projection);
    return projection;
  }

  public QuoteProjectionRoot<PARENT, ROOT> country() {
    getFields().put("country", null);
    return this;
  }

  public QuoteProjectionRoot<PARENT, ROOT> key() {
    getFields().put("key", null);
    return this;
  }

  public QuoteProjectionRoot<PARENT, ROOT> validTo() {
    getFields().put("validTo", null);
    return this;
  }

  public QuoteProjectionRoot<PARENT, ROOT> sellerComment() {
    getFields().put("sellerComment", null);
    return this;
  }

  public QuoteProjectionRoot<PARENT, ROOT> buyerComment() {
    getFields().put("buyerComment", null);
    return this;
  }

  public QuoteProjectionRoot<PARENT, ROOT> purchaseOrderNumber() {
    getFields().put("purchaseOrderNumber", null);
    return this;
  }

  public QuoteProjectionRoot<PARENT, ROOT> id() {
    getFields().put("id", null);
    return this;
  }

  public QuoteProjectionRoot<PARENT, ROOT> version() {
    getFields().put("version", null);
    return this;
  }

  public QuoteProjectionRoot<PARENT, ROOT> createdAt() {
    getFields().put("createdAt", null);
    return this;
  }

  public QuoteProjectionRoot<PARENT, ROOT> lastModifiedAt() {
    getFields().put("lastModifiedAt", null);
    return this;
  }
}
